/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.DBSAP_VendorsDao;
import com.suncode.plugin.biofarm.db.services.DBSAP_VendorsService;
import com.suncode.plugin.biofarm.db.tables.DBSAP_Vendors;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbSAP_VendorsService")
@Transactional
public class DBSAP_VendorsServiceImpl
extends EditableServiceImpl<DBSAP_Vendors, Long, DBSAP_VendorsDao>
implements DBSAP_VendorsService {
    private static final Logger log = LoggerFactory.getLogger(DBSAP_VendorsServiceImpl.class);
    private static final String ZTERM = "ZTERM";
    private static final String VENDOR_NAME = "VENDOR_NAME";
    private static final String VENDOR_ADDRESS = "VENDOR_ADDRESS";
    private static final String NIP = "NIP";
    private static final String COUNTRY = "COUNTRY";
    private static final String ACTIVE = "ACTIVE";
    private static final String LIFNR = "LIFNR";
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(DBSAP_VendorsDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<DBSAP_Vendors> entities) {
        log.debug("SaveOrUpdate Data");
        for (DBSAP_Vendors dbsap_Vendors : entities) {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)dbsap_Vendors);
        }
    }

    @Override
    public DBSAP_Vendors build(Map<String, String> data) {
        String lifnr = data.get(LIFNR);
        DBSAP_Vendors vendors = this.getEntityByfunctionName(lifnr);
        if (vendors == null) {
            vendors = new DBSAP_Vendors();
            vendors.setLifnr(lifnr);
        }
        vendors.setActive(data.get(ACTIVE));
        vendors.setCountry(data.get(COUNTRY));
        vendors.setNip(data.get(NIP));
        vendors.setVendorAddress(data.get(VENDOR_ADDRESS));
        vendors.setVendorName(data.get(VENDOR_NAME));
        vendors.setZterm(data.get(ZTERM));
        return vendors;
    }

    @Override
    public List<DBSAP_Vendors> build(List<Map<String, String>> datas) {
        log.debug("Data conversion");
        ArrayList<DBSAP_Vendors> returnEntites = new ArrayList<DBSAP_Vendors>();
        for (Map<String, String> data : datas) {
            returnEntites.add(this.build(data));
        }
        return returnEntites;
    }

    @Override
    public void updateTable(List<Map<String, String>> datas) {
        this.saveAll(this.build(datas));
    }

    @Override
    public void deleteAll() {
        log.debug("Clear table: " + DBSAP_Vendors.class.getName());
        String stringQuery = "DELETE FROM " + DBSAP_Vendors.class.getName();
        Query query = this.sessionFactory.getCurrentSession().createQuery(stringQuery);
        query.executeUpdate();
    }

    private DBSAP_Vendors getEntityByfunctionName(String lifnr) {
        return (DBSAP_Vendors)this.sessionFactory.getCurrentSession().byNaturalId(DBSAP_Vendors.class).using("lifnr", (Object)lifnr).load();
    }
}

