/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.DBSAP_VatDao;
import com.suncode.plugin.biofarm.db.services.DBSAP_VatService;
import com.suncode.plugin.biofarm.db.tables.DBSAP_Vat;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbAP_VatService")
@Transactional
public class DBSAP_VatServiceImpl
extends EditableServiceImpl<DBSAP_Vat, Long, DBSAP_VatDao>
implements DBSAP_VatService {
    private static final Logger log = LoggerFactory.getLogger(DBSAP_VatServiceImpl.class);
    private static final String WARTOSC_STAWKI = "WARTOSC_STAWKI";
    private static final String OPIS_STAWKI = "OPIS_STAWKI";
    private static final String KOD_STAWKI = "KOD_STAWKI";
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(DBSAP_VatDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<DBSAP_Vat> entities) {
        log.debug("Save Data");
        for (DBSAP_Vat entity : entities) {
            this.save(entity);
        }
    }

    @Override
    public DBSAP_Vat build(Map<String, String> data) {
        DBSAP_Vat returnEntite = new DBSAP_Vat();
        returnEntite.setKodStawki(data.get(KOD_STAWKI));
        returnEntite.setOpisStawki(data.get(OPIS_STAWKI));
        returnEntite.setWartoscStawki(StringUtils.isBlank((CharSequence)data.get(WARTOSC_STAWKI)) ? 0L : Long.valueOf(data.get(WARTOSC_STAWKI)));
        return returnEntite;
    }

    @Override
    public List<DBSAP_Vat> build(List<Map<String, String>> datas) {
        log.debug("Convert Data");
        ArrayList<DBSAP_Vat> returnEntites = new ArrayList<DBSAP_Vat>();
        for (Map<String, String> data : datas) {
            returnEntites.add(this.build(data));
        }
        return returnEntites;
    }

    @Override
    public void updateTable(List<Map<String, String>> datas) {
        this.deleteAll();
        this.saveAll(this.build(datas));
    }

    @Override
    public void deleteAll() {
        log.debug("Clear Table: " + DBSAP_Vat.class.getName());
        String stringQuery = "DELETE FROM " + DBSAP_Vat.class.getName();
        Query query = this.sessionFactory.getCurrentSession().createQuery(stringQuery);
        query.executeUpdate();
    }
}

