/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.DBSAP_PSPDao;
import com.suncode.plugin.biofarm.db.services.DBSAP_PSPService;
import com.suncode.plugin.biofarm.db.tables.DBSAP_PSP;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbSAP_PSPService")
@Transactional
public class DBSAP_PSPServiceImpl
extends EditableServiceImpl<DBSAP_PSP, Long, DBSAP_PSPDao>
implements DBSAP_PSPService {
    private static final Logger log = LoggerFactory.getLogger(DBSAP_PSPServiceImpl.class);
    private static final String PSPID = "PSPID";
    private static final String POST1 = "POST1";
    private static final String ACTIVE = "ACTIVE";
    private static final String FKSTL = "FKSTL";
    private static final String PSPNR = "PSPNR";
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(DBSAP_PSPDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<DBSAP_PSP> entities) {
        log.debug("SaveOrUpdate Data");
        for (DBSAP_PSP dbsap : entities) {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)dbsap);
        }
    }

    @Override
    public DBSAP_PSP build(Map<String, String> data) {
        String pspnr = StringUtils.isBlank((CharSequence)data.get(PSPNR)) ? "" : data.get(PSPNR);
        DBSAP_PSP entity = this.getEntityByfunctionName(pspnr);
        if (entity == null) {
            entity = new DBSAP_PSP();
            entity.setPspnr(pspnr);
        }
        entity.setFkstl(data.get(FKSTL));
        entity.setActive(data.get(ACTIVE));
        entity.setPost1(data.get(POST1));
        entity.setPspid(data.get(PSPID));
        return entity;
    }

    @Override
    public List<DBSAP_PSP> build(List<Map<String, String>> datas) {
        log.debug("Data conversion");
        ArrayList<DBSAP_PSP> returnEntites = new ArrayList<DBSAP_PSP>();
        for (Map<String, String> data : datas) {
            returnEntites.add(this.build(data));
        }
        return returnEntites;
    }

    @Override
    public void updateTable(List<Map<String, String>> datas) {
        this.saveAll(this.build(datas));
    }

    @Override
    public void deleteAll() {
        log.debug("Clear table: " + DBSAP_PSP.class.getName());
        String stringQuery = "DELETE FROM " + DBSAP_PSP.class.getName();
        Query query = this.sessionFactory.getCurrentSession().createQuery(stringQuery);
        query.executeUpdate();
    }

    private DBSAP_PSP getEntityByfunctionName(String param) {
        return (DBSAP_PSP)this.sessionFactory.getCurrentSession().byNaturalId(DBSAP_PSP.class).using("pspnr", (Object)param).load();
    }
}

