/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.db.services;

import com.suncode.plugin.biofarm.db.dao.DBSAP_OrdersDao;
import com.suncode.plugin.biofarm.db.services.DBSAP_OrdersService;
import com.suncode.plugin.biofarm.db.tables.DBSAP_Orders;
import com.suncode.plugin.biofarm.db.tables.DBSAP_Vat;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dbSAP_OrdersService")
@Transactional
public class DBSAP_OrdersServiceImpl
extends EditableServiceImpl<DBSAP_Orders, Long, DBSAP_OrdersDao>
implements DBSAP_OrdersService {
    private static final Logger log = LoggerFactory.getLogger(DBSAP_OrdersServiceImpl.class);
    private static final String ACTIVE = "ACTIVE";
    private static final String KTEXT = "KTEXT";
    private static final String KOSTV = "KOSTV";
    private static final String AUART = "AUART";
    private static final String AUFNR = "AUFNR";
    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    public void setDao(DBSAP_OrdersDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveAll(List<DBSAP_Orders> entities) {
        log.debug("SaveOrUpdate Data");
        for (DBSAP_Orders dbsap : entities) {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)dbsap);
        }
    }

    @Override
    public DBSAP_Orders build(Map<String, String> data) {
        String aufnr = data.get(AUFNR);
        DBSAP_Orders order = this.getEntityByfunctionName(aufnr);
        if (order == null) {
            order = new DBSAP_Orders();
            order.setAufnr(aufnr);
        }
        order.setActive(data.get(ACTIVE));
        order.setAuart(data.get(AUART));
        order.setKostv(data.get(KOSTV));
        order.setKtext(data.get(KTEXT));
        return order;
    }

    @Override
    public List<DBSAP_Orders> build(List<Map<String, String>> datas) {
        log.debug("Data conversion");
        ArrayList<DBSAP_Orders> returnEntites = new ArrayList<DBSAP_Orders>();
        for (Map<String, String> data : datas) {
            returnEntites.add(this.build(data));
        }
        return returnEntites;
    }

    @Override
    public void updateTable(List<Map<String, String>> datas) {
        this.saveAll(this.build(datas));
    }

    @Override
    public void deleteAll() {
        log.debug("Clear table: " + DBSAP_Vat.class.getName());
        String stringQuery = "DELETE FROM " + DBSAP_Vat.class.getName();
        Query query = this.sessionFactory.getCurrentSession().createQuery(stringQuery);
        query.executeUpdate();
    }

    private DBSAP_Orders getEntityByfunctionName(String aufnr) {
        return (DBSAP_Orders)this.sessionFactory.getCurrentSession().byNaturalId(DBSAP_Orders.class).using("aufnr", (Object)aufnr).load();
    }
}

