/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.biofarm.datachooser;

import com.suncode.plugin.biofarm.Categories;
import com.suncode.plugin.biofarm.sap.services.SAPSynchronization;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class BankAcctDatachooser {
    private static final Logger log = LoggerFactory.getLogger(BankAcctDatachooser.class);
    private static final String BVTYP = "BVTYP";
    private static final String IBAN = "IBAN";
    private static final String I_LIFNR = "I_LIFNR";
    @Autowired
    SAPSynchronization sapSynchronization;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("biofarm-dc.bank-acct")).name("biofarm-dc.bank-acct.name")).description("biofarm-dc.bank-acct.desc")).category(new Category[]{Categories.SAP})).icon((Icon)SilkIconPack.MONEY)).parameter().id("lifnr").name(I_LIFNR).description("biofarm-dc.bank-acct.lifnr.desc").type((Type)Types.STRING).create()).mapping().id(IBAN.toLowerCase()).name(IBAN).description("biofarm-dc.bank-acct.IBAN.desc").create().mapping().id(BVTYP.toLowerCase()).name(BVTYP).description("biofarm-dc.bank-acct.BVTYP.desc").create();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, @Param String lifnr) throws Exception {
        if (StringUtils.isBlank((CharSequence)lifnr)) {
            log.debug("No set input parametr LIFNR");
            return;
        }
        CountedResult<Map<String, String>> cResult = this.sapSynchronization.getBankAccounts(lifnr);
        List<Map<String, String>> data = cResult.getData();
        if (StringUtils.isNotBlank((CharSequence)queryData.getQuery())) {
            data = this.filtrData(cResult.getData(), queryData);
        }
        this.paginationData(data, queryData.getPagination(), result);
    }

    private List<Map<String, String>> filtrData(List<Map<String, String>> data, ComponentQueryData queryData) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String query = queryData.getQuery();
        for (Map<String, String> mapData : data) {
            if (!mapData.get(BVTYP.toLowerCase()).toUpperCase().contains(query.toUpperCase()) && !mapData.get(IBAN.toLowerCase()).toUpperCase().contains(query.toUpperCase())) continue;
            result.add(mapData);
        }
        return result;
    }

    private void paginationData(List<Map<String, String>> results, Pagination pagination, DataChooserResult result) {
        int total = results.size();
        results = results.size() > pagination.getLimit() + pagination.getStart() ? results.subList(pagination.getStart(), pagination.getStart() + pagination.getLimit()) : results.subList(pagination.getStart(), results.size());
        List<Map<String, String>> data = results;
        List dataWithLowerKeys = data.stream().map(mapa -> mapa.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue))).collect(Collectors.toList());
        result.setData(dataWithLowerKeys);
        result.setTotal(total);
    }
}

