window.BARCODEPRINT={
	t: PW.I18N.createT('com.suncode.plugin-barcode-printer')
}
/**
 * Wysyła kody zpl z przeglądarki web bezpośrednio na podłączoną lokalnie przez USB drukarkę Zebra.
 * Wymaga zainstalowanego programu Browser Print na komputerze do którego jest podłączona drukarka.
 * Oraz podpięcia do PWFL modułu Barcode Printer, który zawiera potrzebną bibliotekę BrowserPrint.js
 */
window.ZebraBrowserPrint = window.ZebraBrowserPrint || {
	zebraPrinter: null,
	defaultConfig: {
		maxNumberOfZpls: 100,
		zplBeginingSigns: "^XA",
		zplFinisheSigns: "^XZ",
		printerConfigString: "^CWZ,E:TT0003M_.FNT^CI28^CFZ,40,30",
		isErrorAlertEnabled: true,
		zplBeginingRegex: null,
		zplFinisheRegex: null
	},
	messages:  BARCODEPRINT.t
};
jQuery.extend(ZebraBrowserPrint, {
    /** Wysyła na drukarkę otrzymane kody zpl. Pakietami jeśli jest taka potrzeba.
     *  @param zpls - wiele kodów zpl, złączonych w jeden ciąg
     *  @param customConfig - obiekt opcjonalnej własnej konfiguracji drukowania, nadpisuje domyślną, gdzie parametry :
     *  	maxNumberOfZpls - limit liczby zpl'i w jednym pakiecie, po przekroczeniu którego dzieli na pakiety
     *  	printerConfigString - ustawienia dot wydruku etykiet, podane w języku Zebra Zpl
     *  @throws 'barcode-printer.zebra.notfound' gdy nie znaleziono podłączonej drukarki Zebra
     *  @throws 'barcode-printer.zebra.printingerror'gdy wystąpił błąd drukarki podczas przesyłania do niej danych
     */
	printzpls: function (zpls, customConfig) {
		var printingConfig = ZebraBrowserPrint._buildPrintingConfig(customConfig);
		if (ZebraBrowserPrint.zebraPrinter) {
			ZebraBrowserPrint._print(zpls, printingConfig);
		}
		else {
			BrowserPrint.getDefaultDevice('printer', ZebraBrowserPrint._print.bind(this, zpls, printingConfig), ZebraBrowserPrint._printerSetupError.bind(this, printingConfig));
		}
	},
	_buildPrintingConfig: function (newConfig) {
		var printingConfig = jQuery.extend({}, ZebraBrowserPrint.defaultConfig, newConfig);
		if (printingConfig.maxNumberOfZpls < 1) {
			printingConfig.maxNumberOfZpls = 1;
		}
		if (printingConfig.maxNumberOfZpls > 1000) {
			printingConfig.maxNumberOfZpls = 1000;
		}
		printingConfig.zplBeginingRegex = new RegExp("^" + printingConfig.zplBeginingSigns.replace("^", "\\^"));
		printingConfig.zplFinisheRegex = new RegExp(printingConfig.zplFinisheSigns.replace("^", "\\^") + "$");

		printingConfig.printerConfigString = printingConfig.printerConfigString.replace(printingConfig.zplBeginingRegex, "")
			.replace(printingConfig.zplFinisheRegex, "");
		printingConfig.printerConfigString = printingConfig.zplBeginingSigns + printingConfig.printerConfigString
			+ printingConfig.zplFinisheSigns;
		if (printingConfig.isErrorAlertEnabled != false) {
			printingConfig.isErrorAlertEnabled = ZebraBrowserPrint.defaultConfig.isErrorAlertEnabled;
		}

		return printingConfig;
	},
	_print: function (zpls, printingConfig, foundPrinter) {
		if (foundPrinter) {
			ZebraBrowserPrint.zebraPrinter = foundPrinter;
			ZebraBrowserPrint._log("Zebra printer has been found: " + ZebraBrowserPrint.zebraPrinter.manufacturer + " (" + ZebraBrowserPrint.zebraPrinter.name + ").");
		}
		zpls = zpls.replace(/Ę/g, "_c4_98").replace(/Ł/g, "_c5_81").replace(/Ń/g, "_c5_83");
		var tabZpls = zpls.split(printingConfig.zplFinisheSigns);
		var numberOfParts = Math.ceil(tabZpls.length / printingConfig.maxNumberOfZpls);
		var zplpart = "";
		var numberOfAddedParts = 0;

		for (var i = 0; i < tabZpls.length; i++) {
			if (printingConfig.zplBeginingRegex.test(tabZpls[i])) {
				zplpart += tabZpls[i] + printingConfig.zplFinisheSigns;
				numberOfAddedParts++;
			}
			if (numberOfAddedParts == printingConfig.maxNumberOfZpls || i == tabZpls.length - 1) {
				ZebraBrowserPrint._printzplspart(zplpart, printingConfig);
				zplpart = "";
				numberOfAddedParts = 0;
			}
		}
	},
	_printzplspart: function (zplpart, printingConfig) {
		if (zplpart == undefined || zplpart.trim().length < 1)
			return;
		ZebraBrowserPrint.zebraPrinter.send(printingConfig.printerConfigString + zplpart, ZebraBrowserPrint._printingCompleted, ZebraBrowserPrint._printingError.bind(this, printingConfig));
	}
});

jQuery.extend(ZebraBrowserPrint, {
	_log: function (message) {
		if (typeof console == "undefined") {
			return;
		}
		console.log(message);
	},
	_alert: function (messageKey, printingConfig) {
		if (printingConfig.isErrorAlertEnabled) {
			alert(ZebraBrowserPrint.messages(messageKey) + "\n" + ZebraBrowserPrint.messages('barcode-printer.zebra.alertinfo'));
		}
		else {
			ZebraBrowserPrint._log(ZebraBrowserPrint.messages(messageKey, 'en'));

			throw messageKey;
		}
	},
	_printerSetupError: function (printingConfig, text) {
		ZebraBrowserPrint._alert('barcode-printer.zebra.notfound', printingConfig);
	},
	_printingCompleted: function () {
		ZebraBrowserPrint._log("ZPL's data has been sent to Zebra printer.");
	},
	_printingError: function (printingConfig, text) {
		ZebraBrowserPrint.zebraPrinter = null;
		ZebraBrowserPrint._alert('barcode-printer.zebra.printingerror', printingConfig);
	}
});
