PW.FormActions.create('label-print-dymo-action', {
    defaultActions: {
        button: function () {
            this.loadTemplateAndPrint()
        }
    },

    loadTemplateAndPrint: function () {
        let me = this;
        let templateName = this.get("templateName");
        let processDefId = ActivityInfoService.getProcessDefId();
        jQuery.ajax({
            type: "GET",
            url: "plugin/com.suncode.plugin-barcode-printer/label/template/",
            data: {
                templateName: templateName,
                processDefId: processDefId
            },
            error: function (jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            },
            async: true
        })
            .done(function (data) {
                me.printLabel(data)
            })
            .fail(function () {
                Logger.error("No label template found.");
                MessageService.showFailure(BARCODEPRINT.t('action.print-dymo-label-action.no-label-found.error'));
            })
    },

    printLabel: function (data) {
        let label = dymo.label.framework.openLabelXml(data);
        if (!label) {
            Logger.error("Load label before printing");
            return;
        }
        // set data using LabelSet and text markup
        let labelSet = new dymo.label.framework.LabelSetBuilder();
        let record = labelSet.addRecord();

        let templateVariable = this.get("templateVariable");
        let processVariable = this.get("processVariable");
        let isDymoConnectLabelType = label.isDCDLabel();

        for (let i = 0; i < templateVariable.length; i++) {
            if (isDymoConnectLabelType) {
                record.setText(templateVariable[i], processVariable[i]);
            } else {
                record.setTextMarkup(templateVariable[i], processVariable[i]);
            }
        }

        let printers = dymo.label.framework.getPrinters();
        if (printers.length === 0) {
            MessageService.showFailure(BARCODEPRINT.t('action.print-dymo-label-action.no-printer-installed.error'));
            throw "No DYMO printers are installed. Install DYMO printers.";
        }

        let targetModelName = isDymoConnectLabelType ? "DYMO LabelWriter 550" : "DYMO LabelWriter 450";
        let filteredPrinters = printers.filter(printer => printer.modelName === targetModelName);
        let foundPrinter = filteredPrinters.length > 0 ? filteredPrinters[0] : undefined;

        let printerName = "";
        if (foundPrinter !== undefined) {
            printerName = foundPrinter.name;
        } else {
            for (let i = 0; i < printers.length; ++i) {
                let printer = printers[i];
                if (printer.printerType === "LabelWriterPrinter") {
                    printerName = printer.name;
                    break;
                }
            }
        }

        if (printerName === "") {
            MessageService.showFailure(BARCODEPRINT.t('action.print-dymo-label-action.no-printer-found.error'));
            throw "No LabelWriter printers found. Install LabelWriter printer";
        }
        label.print(printerName, null, labelSet.toString());
    }
});