PW.FormActions.create('barcode-print-action', {
    // domyślne akcje
    defaultActions: {
        button: function (button) {
        	var code = this.get("code");
            var labels = this.buildLabels(code, this.get("isZpls"));
            ZebraBrowserPrint.printzpls(labels,{
            	maxNumberOfZpls: code.length
            });
            this.confirmPrint();
        },
    },
    defaultZpls: function (string) {
        return "^XA" +
            "^FO40,20^BY3^BCN,80,N^FD" + string + "^FS" +
            "^FO160,120^FD" + string + "^FS" +
            "^XZ";
    },
    buildLabels: function (array, isZpls) {
        var temp = "";
        for (index = 0; index < array.length; index++) {
            temp += isZpls ? array[index] : this.defaultZpls(array[index]);
        }
        return temp;
    },
    confirmPrint: function () {
        if (this.get("showManualConfirm")) {
            var resultPrinter = this.get("resultPrinter");
            ServiceFactory.getMessageService().showConfirm({
                title: BARCODEPRINT.t("barcode-printer.confirm.title"),
                message: BARCODEPRINT.t("barcode-printer.confirm.msg"),
                yes: function () {
                    if (resultPrinter) {
                        VariableService.setValue(resultPrinter.getId(), true);
                    }
                },
                no: function () {
                    if (resultPrinter) {
                        VariableService.setValue(resultPrinter.getId(), false);
                    }
                }
            });
        }
    }
});