PWE.integrationComponent.registerFormAction('table-detach-all', {
    apiVersion: 2,
    buildForm: function (form, options) {
        const destination = options.destination;

        form.addField("column-file-id");
        form.addField({
            id: "detach-button-name",
            hidden: destination === "DT_BUTTON"
        });
        addComboboxIconList("detach-icon-name", null, form, null, destination === "DT_BUTTON");
        form.addField("deleteFromArch");
        form.addField("msgSuccess");
        form.addField("msgError");
        form.addField("msgDocNotAttach");
        form.addField({
            id: "remove-row",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("clear-cell")
                    } else {
                        form.show("clear-cell")
                    }
                }
            }
        });
        form.addField({ id: "clear-cell", hidden: true });
        form.addField({
            id: "warnDetachAtachments",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("detachConfirmTitle")
                        form.show("detachConfirmMsg")
                    } else {
                        form.hide("detachConfirmTitle")
                        form.hide("detachConfirmMsg")
                    }
                }
            }
        });
        form.addField({ id: "detachConfirmTitle", hidden: true });
        form.addField({ id: "detachConfirmMsg", hidden: true });
        if (form.getValue("warnDetachAtachments", false)) {
            form.show("detachConfirmTitle")
            form.show("detachConfirmMsg")
        }
        if (form.getValue("remove-row", false) == false) {
            form.show("clear-cell")
        }
        function addComboboxIconList(idName, listenersFn, form, position, hidden) {
            form.addCombobox({
                id: idName,
                hidden: hidden,
                optional: true,
                remote: {
                    url: "plugin/com.suncode.plugin-attachment/api/icon",
                    fields: [
                        {
                            name: "iconName",
                            type: "string"
                        },
                    ]
                },

                valueField: "iconName",
                displayField: "iconName",
                sort: [{
                    property: "iconName",
                    direction: "ASC"
                }],
                listeners: listenersFn
            }, position)
        }
    }
});