PWE.integrationComponent.registerApplication("attachment.duals.InsertGraphicFileToPdf", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
    validateForm: (api) => validateForm(api)
});

PWE.integrationComponent.registerVariablesSetter("attachment.duals.InsertGraphicFileToPdf", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
    validateForm: (form) => validateForm(form)
});

function buildForm(form) {
    form.addField("fileId");
    addPdfImageInsertionSettings(form);
    addOutputPdfSaveSettings(form);
}

function addPdfImageInsertionSettings(form) {
    let pdfImageInsertionSettings = form.addFieldSet({
        id: "pdf-image-insertion-settings-fs",
        collapsible: true,
        collapsed: false,
        title: Attachment.t("attachment.duals.InsertGraphicFileToPdf.pdfImageInsertionSettings.fieldSet.name")
    });
    pdfImageInsertionSettings.addCombobox({
        id: "graphicFileSource",
        values: [
            { id: "ABSOLUTE_PATH", display: Attachment.t("attachment.duals.InsertGraphicFileToPdf.graphicFileSource.absolutePath") },
            { id: "DOCUMENT_ARCHIVE", display: Attachment.t("attachment.duals.InsertGraphicFileToPdf.graphicFileSource.documentArchive") }
        ],
        listeners: {
            change: function(value) {
                if (value === "ABSOLUTE_PATH") {
                    toggleFieldsWhenGraphicFileSourceIsAbsolutePath(pdfImageInsertionSettings);
                } else if (value === "DOCUMENT_ARCHIVE") {
                    toggleFieldsWhenGraphicFileSourceIsDocumentArchive(pdfImageInsertionSettings);
                } else if (pdfImageInsertionSettings.hasFunctionValue("graphicFileSource") ||
                    pdfImageInsertionSettings.hasVariableValue("graphicFileSource")) {
                    toggleFieldsWhenGraphicFileSourceIsFunctionOrVariable(pdfImageInsertionSettings);
                } else {
                    toggleFieldsWhenGraphicFileSourceIsUndefined(pdfImageInsertionSettings);
                }
            }
        }
    });

    pdfImageInsertionSettings.addField("graphicFilePath");
    pdfImageInsertionSettings.addField("graphicFileId");
    Attachment.addComboboxImagePositionList("imageDestinationPage", pdfImageInsertionSettings,
        "plugin/com.suncode.plugin-attachment/config/graphicFile/pageDestination",  null);
    Attachment.addComboboxImagePositionList("imagePositionOnPage", pdfImageInsertionSettings,
        "plugin/com.suncode.plugin-attachment/config/graphicFile/positionOnPage", null);
    pdfImageInsertionSettings.addField("graphicsWidth");
    pdfImageInsertionSettings.addField("documentScaling");
    afterPdfImageInsertionSettingsLoad(pdfImageInsertionSettings);
}

function addOutputPdfSaveSettings(form) {
    let outputPdfSaveSettings = form.addFieldSet({
        id: "output-pdf-save-settings-fs",
        collapsible: true,
        collapsed: false,
        title: Attachment.t("attachment.duals.InsertGraphicFileToPdf.outputPdfSaveSettings.fieldSet.name")
    });
    outputPdfSaveSettings.addField({
        id: "saveAsNewVersion",
        listeners: {
            change: function(value) {
                if (!value) {
                    toggleFieldsWhenSaveAsNewVersionIsFalse(outputPdfSaveSettings);
                } else if (outputPdfSaveSettings.hasFunctionValue("saveAsNewVersion") || outputPdfSaveSettings.hasVariableValue("saveAsNewVersion")) {
                    toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(outputPdfSaveSettings);
                } else {
                    toggleFieldsWhenSaveAsNewVersionIsTrue(outputPdfSaveSettings);
                }
            }
        }
    });
    Attachment.addComboboxClassList("targetDocumentClassName", null, outputPdfSaveSettings, null);
    outputPdfSaveSettings.addField("addDocumentToProcess");
    outputPdfSaveSettings.addField("executeArchiveActions");
    afterOutputPdfSaveSettingsLoad(outputPdfSaveSettings);
}

function afterPdfImageInsertionSettingsLoad(form) {
    if (form.getValue("graphicFileSource") === "ABSOLUTE_PATH") {
        toggleFieldsWhenGraphicFileSourceIsAbsolutePath(form);
    } else if (form.getValue("graphicFileSource") === "DOCUMENT_ARCHIVE") {
        toggleFieldsWhenGraphicFileSourceIsDocumentArchive(form);
    } else if (form.hasFunctionValue("graphicFileSource") || form.hasVariableValue("graphicFileSource")) {
        toggleFieldsWhenGraphicFileSourceIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenGraphicFileSourceIsUndefined(form);
    }
}

function toggleFieldsWhenGraphicFileSourceIsAbsolutePath(form) {
    form.setNotEmpty("graphicFilePath", true);
    form.show("graphicFilePath");
    form.setNotEmpty("graphicFileId", false);
    form.hide("graphicFileId");
}

function toggleFieldsWhenGraphicFileSourceIsDocumentArchive(form) {
    form.setNotEmpty("graphicFileId", true);
    form.show("graphicFileId");
    form.setNotEmpty("graphicFilePath", false);
    form.hide("graphicFilePath");
}

function toggleFieldsWhenGraphicFileSourceIsFunctionOrVariable(form) {
    form.setNotEmpty("graphicFileId", false);
    form.show("graphicFileId");
    form.setNotEmpty("graphicFilePath", false);
    form.show("graphicFilePath");
}

function toggleFieldsWhenGraphicFileSourceIsUndefined(form) {
    form.setNotEmpty("graphicFileId", false);
    form.hide("graphicFileId");
    form.setNotEmpty("graphicFilePath", false);
    form.hide("graphicFilePath");
}

function afterOutputPdfSaveSettingsLoad(form) {
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveAsNewVersionIsTrue(form);
    }
}

function toggleFieldsWhenSaveAsNewVersionIsFalse(form) {
    form.setNotEmpty("targetDocumentClassName", true);
    form.show("targetDocumentClassName");
    form.show("addDocumentToProcess");
    form.show("executeArchiveActions");
}

function toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form) {
    form.setNotEmpty("targetDocumentClassName", false);
    form.show("targetDocumentClassName");
    form.show("addDocumentToProcess");
    form.show("executeArchiveActions");
}

function toggleFieldsWhenSaveAsNewVersionIsTrue(form) {
    form.setNotEmpty("targetDocumentClassName", false);
    form.hide("targetDocumentClassName");
    form.hide("addDocumentToProcess");
    form.hide("executeArchiveActions");
}

function validateForm(api) {
    let graphicsWidth = api.getValue("graphicsWidth");
    if (graphicsWidth < 1 || graphicsWidth > 100) {
        api.markError("graphicsWidth");
        api.showErrorMessage(Attachment.t("attachment.InsertGraphicFileToPdf.graphicsWidth.errorMessage"));
        return false;
    }
}
