PW.FormActions.create('attachment-table-multi-manager', {

    variableSetInit: function (table) {
        this.tableId = table.getId();
    },

    enable: function () {
        this.initButtonFun();
        let me = this;
        this.table = VariableSetService.get(this.tableId);

        const rowsCount = VariableSetService.getRowsCount(this.table);
        const columnId = this.get("manager-column").getId();
        FormService.mask();
        for (let index = 0; index < rowsCount; index++) {
            let result = VariableSetService.getValue(this.table, index, columnId);
            if (!result) {
                result = new Array();
                VariableSetService.setValue(this.table, index, columnId, JSON.stringify(result));
            } else {
                result = JSON.parse(result);
                this.checkAttachDocs(result, this.table, index, columnId);
            }

        }
        FormService.unmask();
        VariableSetService.addRenderer(this.table, function (value, data,
                                                             column, metaData) {
            metaData.encode = false;
            let div = jQuery("<div/>");
            div.append(me.createMultiManager(value, data, column, metaData));
            return div.html();
        }, [this.get("manager-column").getId()]);

        FormService.save();
    },

    disable: function () {
        VariableSetService.removeRenderers(this.table, [this.get(
            "manager-column").getId()]);
    },

    createMultiManager: function (value, data, column, metaData) {
        let button = this.buildTamplateButton();
        let cfg = new Object();
        cfg.tableId = this.tableId;
        cfg.columnId = this.get("manager-column").getId();
        cfg.rowIndex = metaData.row;
        cfg.addCfg = new Object();
        cfg.addCfg.showIndexes = this.get("show-indexes");
        cfg.addCfg.checkRights = this.get("check-rights");
        cfg.addCfg.autoSelectFirst = this.get("auto-select-first");
        cfg.addCfg.hide = this.get("hide-add-btn");
        cfg.addCfg.docClasses = new Array();
        jQuery.each(this.get("doc-class-name"), function (index, value) {
            if (value != undefined && value != null) {
                cfg.addCfg.docClasses.push(value);
            }
        });
        cfg.detachCfg = new Object();
        cfg.detachCfg.warningDeatach = this.get("warning-detach");
        cfg.detachCfg.hide = this.get("hide-deatch-btn");
        cfg.detachCfg.detachMode = this.getDetachMode();
        cfg.detachCfg.removeFromArchive = this.get("remove-from-archive");
        cfg.hideCol = this.get("hide-col");
        cfg.showCfg = new Object();
        cfg.showCfg.hide = this.get("hide-show-btn");
        button.attr('onClick', 'Attachment.openMultiManager(this,"' + this.get("manager-button-name") + '")');
        button.attr("data-cfg", JSON.stringify(cfg));
        button.append(this.createIconSpan("folder-page"));
        let count = 0;
        if (value) {
            count = JSON.parse(value).length;
        }
        button.append(this.createNameSpan(this.get("manager-button-name") + " (" + count + ")"));
        button.get(0).disabled = this.processRowCondition(metaData.row);
        return button;
    },

    getDetachMode: function () {
        let detachMode = this.get("detach-mode");
        if (!detachMode) {
            detachMode = (this.get("deatch-owner") ? "OWN_DOCUMENT" : "NOT_ALLOWED")
        }

        return detachMode;
    },

    createIconSpan: function (icon) {
        let span = jQuery("<span/>");
        span.addClass("x4-btn-icon-el");
        span.addClass("silk-" + icon);
        span.css("margin-left", "5px");
        span.text(" ")
        return span;
    },

    createNameSpan: function (name) {
        let span = jQuery("<span/>");
        span.addClass("x4-btn-inner");
        span.addClass("x4-btn-inner-center");
        span.css("margin-left", "5px");
        span.append(name);
        return span;
    },

    buildTamplateButton: function () {
        let button = jQuery("<button/>");
        button.addClass("x4-btn")
        button.addClass("x4-btn-default-small-icon-text-left")

        button.attr('style', 'width: 96% !important;')
        button.css("line-height", "16px");
        button.css("padding", "0px");

        return button;
    },

    initButtonFun: function () {
        Attachment.openMultiManager = this.openWindow;
    },

    openWindow: function (me, titile) {
        let data = jQuery(me).data("cfg");
        PW.ui.ModalWindow.show(titile,
            "plugin/com.suncode.plugin-attachment/multimanager/" + btoa(encodeURIComponent(JSON.stringify(data))),
            {
                bodyCls: "form-document-info-window",
                iconCls: "silk-folder-page",
                shadow: false,
                width: "auto",
                xtype: "window",
                maxWidth: window.screen.availWidth - 50
            }
        );
    },

    checkAttachDocs: function (result, table, index, columnId) {
        let fileArray = new Array();
        jQuery.each(result, function (index, value) {
            fileArray.push(value.id);
        });
        if (fileArray.length > 0) {
            jQuery.ajax({
                url: 'plugin/com.suncode.plugin-attachment/api/docs/getRemoveFileIds',
                type: "post",
                async: true,
                data: {
                    fileids: fileArray,
                    processid: processId,
                    activityid: activityId
                },
                dataType: 'json',
                success: function (dataResult) {
                    let removeDoc = dataResult.data;
                    if (removeDoc.length != 0) {
                        let updateResult = new Array();
                        jQuery.each(result, function (index, value) {
                            if (removeDoc.indexOf(value.id) < 0) {
                                updateResult.push(value);
                            }
                        });
                        result = updateResult;
                        VariableSetService.setValue(table, index, columnId, JSON.stringify(result));
                        FormService.save();
                    }
                }
            });
        }
        return result;
    },

    processRowCondition: function(rowIndex) {
        this.setContextVariable("currentRow", rowIndex);
        if (this.get("condition")) {
            if (this.get("condition").call()) {
                return true;
            }
        }
        return false;
    },
});