var variableService = ServiceFactory.getVariableService();
var messageService = ServiceFactory.getMessageService();
var variableSetService = ServiceFactory.getVariableSetService();

PW.FormActions.create('table-manager-attachment', {

    variableSetInit: function (variableSet) {

        var funcAdd = this.addButtonFunc;
        var buttonNameAdd = this.get("add-button-name");
        var iconNameAdd = this.get("add-icon-name");

        var funcDelete = this.deleteButtonFunc;
        var buttonNameDelete = this.get("delete-button-name");
        var iconNameDelete = this.get("delete-icon-name");

        var funcUpdate = this.updateButtonFunc;
        var buttonNameUpdate = this.get("update-button-name");
        var iconNameUpdate = this.get("update-icon-name");

        var funcShow = this.showButtonFunc;
        var buttonNameShow = this.get("show-button-name");
        var iconNameShow = this.get("show-icon-name");



        var table = variableSetService.get(variableSet.getId());
        var settings = new Object();
        settings["column-file-id"] = this.get("column-file-id");
        settings["column-doc-id"] = this.get("column-doc-id");
        settings["column-file-date"] = this.get("column-file-date");
        settings["column-file-name"] = this.get("column-file-name");
        settings["column-file-descripton"] = this.get("column-file-descripton");
        settings["column-file-class-name"] = this.get("column-file-class-name");
        settings["show-indexes"] = this.get("show-indexes");
        settings["check-rights"] = this.get("check-rights");
        settings["auto-select-first"] = this.get("auto-select-first");
        settings["refresh-after-add"] = this.get("refresh-after-add");
        settings["msg-warning"] = this.get("msg-warning");
        settings["add-new-row"] = this.get("add-new-row");
        var classesList = this.get("doc-class-name");

        variableSetService.addBottomToolbarButton(
            table, {
        	itemId:'addMAttachment',
                iconCls: "silk-" + iconNameAdd,
                text: buttonNameAdd,
                handler: function () {
                    funcAdd(table, settings, classesList);
                }
            });

        variableSetService.addBottomToolbarButton(
            table, {
        	itemId:'deleteMAttachment',
                iconCls: "silk-" + iconNameDelete,
                text: buttonNameDelete,
                handler: function () {
                    funcDelete(table, settings);
                }
            });

        variableSetService.addBottomToolbarButton(
            table, {
        	itemId:'updateMAttachment',
                iconCls: "silk-" + iconNameUpdate,
                text: buttonNameUpdate,
                handler: function () {
                    funcUpdate(table, settings, classesList);
                }
            });

        variableSetService.addBottomToolbarButton(
            table, {
        	itemId:'showMAttachment',
                iconCls: "silk-" + iconNameShow,
                text: buttonNameShow,
                handler: function () {
                    funcShow(table, settings);
                }
            });
    },

    addButtonFunc: function (table, settings, fileClasses) {
        var selectedRow = variableSetService.getSelected(table);
        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: settings["show-indexes"],
            checkRights: settings["check-rights"],
            autoSelectFirst: settings["auto-select-first"],
            documentClassNameList: fileClasses,
            refreshAfterAdd: settings["refresh-after-add"],
            callback: function (file) {
                if (settings["add-new-row"] == true || selectedRow == null) {
                    var row = new Object();
                    if (settings["column-file-date"]) {
                        row[settings["column-file-date"].getId()] = new Date();
                    }
                    if (settings["column-file-id"]) {
                        row[settings["column-file-id"].getId()] = file.id;
                    }
                    if (settings["column-doc-id"]) {
                        var docIdTemp = -1;
                        // console.log('przed '+filetemp);
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                docIdTemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                                ;
                            }
                        });
                        row[settings["column-doc-id"].getId()] = docIdTemp;
                        //row[settings["column-doc-id"].getId()]=file.id;    
                    }
                    if (settings["column-file-name"]) {
                        row[settings["column-file-name"].getId()] = file.fileName;
                    }
                    if (settings["column-file-descripton"]) {
                        row[settings["column-file-descripton"].getId()] = file.description;
                    }
                    if (settings["column-file-class-name"]) {
                        row[settings["column-file-class-name"].getId()] = file.documentClass.name;
                    }
                    variableSetService.addRow(table, false, row);
                } else {

                    var indexRow = variableSetService.getRowIndex(table, selectedRow);
                    if (settings["column-file-date"]) {
                        variableSetService.setValue(table, indexRow, settings["column-file-date"].getId(), new Date());
                    }
                    if (settings["column-file-id"]) {
                        variableSetService.setValue(table, indexRow, settings["column-file-id"].getId(), file.id);
                    }
                    if (settings["column-doc-id"]) {
                        var filetemp = -1;
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                filetemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                                ;
                            }
                        });
                        //  console.log('po ax '+filetemp);
                        variableSetService.setValue(table, indexRow, settings["column-doc-id"].getId(), filetemp);
                    }
                    if (settings["column-file-name"]) {
                        variableSetService.setValue(table, indexRow, settings["column-file-name"].getId(), file.fileName);
                    }
                    if (settings["column-file-descripton"]) {
                        variableSetService.setValue(table, indexRow, settings["column-file-descripton"].getId(), file.description);
                    }
                    if (settings["column-file-class-name"]) {
                        variableSetService.setValue(table, indexRow, settings["column-file-class-name"].getId(), file.documentClass.name);
                    }
                    variableSetService.save(table);
                }
                // Dołączono dokument, zapisujemy więc tabele dyn., żeby po odświeżeniu strony informacja o tym nam nie zniknęła.
                var formService = ServiceFactory.getFormService();
                formService.save();
            }
        });
    },


    deleteButtonFunc: function (table, settings) {
        var selectedRow = variableSetService.getSelected(table);
        if (selectedRow == null) {
            messageService.show(settings["msg-warning"]);
            return;
        }

        var rowIndex = variableSetService.getRowIndex(table, selectedRow);
        messageService.showConfirm({
            title: "Uwaga",
            message: "Usunąć wybrany załącznik?",
            yes: function () {
                // Pobranie id pliku
                var fileId = selectedRow.data[settings["column-file-id"].getId()];

                // Usunięcie wiersza
                table.store.removeAt(rowIndex);

                // Odłaczenie dokumentu od procesu
                var activityId = ServiceFactory.getActivityInfoService().getActivityId(),
                    processId = ServiceFactory.getActivityInfoService().getProcessId();

                CUF.DocumentService.detachDocument(fileId, processId, activityId);

                // Zapis formularza
                var formService = ServiceFactory.getFormService();
                formService.save();

            }
        });
    },

    updateButtonFunc: function (table, settings, fileClasses) {


        var selectedRow = variableSetService.getSelected(table);
        if (selectedRow == null) {

            messageService.show(settings["msg-warning"]);
            return;
        }
        var rowIndex = variableSetService.getRowIndex(table, selectedRow);
        // Wyświetlenie okienka z dodaniem nowego wiersza
        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: settings["show-indexes"],
            checkRights: settings["check-rights"],
            autoSelectFirst: settings["auto-select-first"],
            documentClassNameList: fileClasses,
            refreshAfterAdd: settings["refresh-after-add"],
            callback: function (file) {
                // Odłaczenie starego załacznika od procesu
                var fileId = selectedRow.data[settings["column-file-id"].getId()];
                var activityId = ServiceFactory.getActivityInfoService().getActivityId(),
                    processId = ServiceFactory.getActivityInfoService().getProcessId();
                CUF.DocumentService.detachDocument(fileId, processId, activityId);

                // Podmiana danych

                if (settings["column-file-date"]) {
                    variableSetService.setValue(table, rowIndex, settings["column-file-date"].getId(), new Date());
                }
                if (settings["column-file-id"]) {
                    variableSetService.setValue(table, rowIndex, settings["column-file-id"].getId(), file.id);
                }
                if (settings["column-file-name"]) {
                    variableSetService.setValue(table, rowIndex, settings["column-file-name"].getId(), file.fileName);
                }
                if (settings["column-file-descripton"]) {
                    variableSetService.setValue(table, rowIndex, settings["column-file-descripton"].getId(), file.description);
                }
                if (settings["column-file-class-name"]) {
                    variableSetService.setValue(table, rowIndex, settings["column-file-class-name"].getId(), file.documentClass.name);
                }


                // Dołączono dokument, zapisujemy więc tabele dyn., żeby po odświeżeniu strony informacja o tym nam nie zniknęła.
                var formService = ServiceFactory.getFormService();
                formService.save();
            }
        });
    },

    showButtonFunc: function (table, settings) {
        var selectedRow = variableSetService.getSelected(table);
        if (selectedRow == null) {
            messageService.show(settings["msg-warning"]);
            return;
        }
        var fileId = selectedRow.data[settings["column-file-id"].getId()];
        if (!fileId) {
            return;
        }
        CUF.DocumentService.showFile(parseInt(fileId));
        return true;
    }


});