PW.FormActions.create("attachment.show-attachment", {
    defaultActions: {
        button: function () {
            const fileId = this.get("fileId");
            const msg = this.get("msgDocNotAttach");

            checkFileId(fileId)
                .then((isValid) => {
                    if (isValid) {
                        CUF.DocumentService.showFile(fileId);
                    } else {
                        MessageService.showFailure(msg);
                    }
                });
        }
    }
});

function checkFileId(fileId) {
    return fetch(Suncode.getAbsolutePath("/api/documents/" + fileId + "/versions"))
        .then((response) => response.json())
        .then((json) => json != null && json.length > 0)
        .catch(() => false);
}