/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.attachment.dto.FileInfo;
import com.suncode.plugin.attachment.dto.OptionsDto;
import com.suncode.plugin.attachment.dto.RestResult;
import com.suncode.plugin.attachment.dto.ResultFile;
import com.suncode.plugin.attachment.services.AttachDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.exception.InvalidIndexValueException;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.support.CustomService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private AttachDocumentService attachDocumentService;
    @Autowired
    private ActivityDocumentService activityDocumentService;
    @Autowired
    private FileService fileService;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @ResponseBody
    @RequestMapping(value={"api/docs/getRemoveFileIds"}, method={RequestMethod.POST})
    public CountedResult<Long> getRemoveFileIds(@RequestParam(value="fileids[]") List<Long> filesIds, @RequestParam String processid, @RequestParam String activityid) {
        CountedResult result = new CountedResult();
        LinkedList<Long> filesIdsFromActivity = new LinkedList<Long>(filesIds);
        List activityDocumetns = this.activityDocumentService.getActivityDocuments(processid, activityid, new String[]{"file"});
        for (ActivityDocument activityDocument : activityDocumetns) {
            if (filesIdsFromActivity.isEmpty()) break;
            Long fileId = activityDocument.getFile().getId();
            if (!filesIdsFromActivity.contains(fileId)) continue;
            filesIdsFromActivity.remove(fileId);
        }
        result.setData(filesIdsFromActivity);
        return result;
    }

    @RequestMapping(value={"api/docs/getFile/{fileId}"}, method={RequestMethod.GET})
    @ResponseBody
    public FileInfo getNewestFile(@PathVariable(value="fileId") Long fileId) {
        WfFile wfFile = this.attachDocumentService.getNewestWfFile(fileId, "documentClass", "version.newestFile");
        return this.attachDocumentService.buildFileInfo(wfFile);
    }

    @RequestMapping(value={"api/docs/getOptions"}, method={RequestMethod.GET})
    @ResponseBody
    public OptionsDto getOptionsForAttachmentsInDocument(HttpSession session, @RequestParam(value="processId") String processId, @RequestParam(value="fileId", required=false) Long fileId, @RequestParam(value="showOption") boolean show, @RequestParam(value="addOption") boolean add, @RequestParam(value="detachOption") boolean detach, @RequestParam(value="downloadOption") boolean download, @RequestParam(value="deleteFromArchive") boolean deleteFromArch) {
        ShaKey shaKey = new ShaKey();
        String fileStatus = "";
        String userName = (String)session.getAttribute("username");
        String activityId = (String)session.getAttribute("activityId");
        OptionsDto options = new OptionsDto();
        options.setAddOption(add);
        if (fileId == null) {
            options.setShowOption(show);
            options.setDetachOption(detach);
            options.setDownloadOption(download);
            options.setSaveOption(false);
            options.setCancelOption(false);
        } else {
            options.setShowOption(this.attachDocumentService.hasRightsToReadFile(userName, fileId, shaKey.get(processId)) && show);
            boolean sameUploadersForFileVersions = this.attachDocumentService.checkFileVersionsUploader(fileId, userName);
            if (deleteFromArch) {
                options.setDetachOption(this.attachDocumentService.hasRightsToDeleteFile(userName, fileId) && detach && sameUploadersForFileVersions);
            } else {
                options.setDetachOption(detach && this.attachDocumentService.hasRightsToDetachFile(userName, fileId, processId, activityId));
            }
            if (download && this.attachDocumentService.hasRightsToModifyFile(userName, fileId)) {
                fileStatus = this.fileService.getVersionForFile(fileId).getState();
                if (StringUtils.equalsIgnoreCase((String)fileStatus, (String)"STATE_READY")) {
                    options.setDownloadOption(true);
                    options.setSaveOption(false);
                    options.setCancelOption(false);
                } else if (StringUtils.equalsIgnoreCase((String)fileStatus, (String)"STATE_EDIT")) {
                    options.setDownloadOption(false);
                    options.setSaveOption(true);
                    options.setCancelOption(true);
                }
            } else {
                options.setDownloadOption(false);
                options.setSaveOption(false);
                options.setCancelOption(false);
            }
        }
        return options;
    }

    @RequestMapping(value={"api/docs/getDocumentClassId"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult<Long> getDocumentClassId(@RequestParam(value="fileid") Long fileId, @RequestParam(value="processid") String processId) {
        RestResult<Long> result = new RestResult<Long>();
        WfFile wfFile = this.attachDocumentService.getWfFile(fileId, "documentClass");
        if (wfFile == null) {
            result.setMessage("attachment.msg.docnotfind");
        } else {
            result.setMessage("attachment.msg.docnotattach");
            List activitiesDocuments = this.activityDocumentService.getActivityDocuments(Long.valueOf(wfFile.getId()), new String[]{"process"});
            for (ActivityDocument activityDocument : activitiesDocuments) {
                if (!activityDocument.getProcess().getProcessId().equals(processId)) continue;
                result.setData(wfFile.getDocumentClass().getId());
                result.setSuccess(true);
                result.setMessage("");
                break;
            }
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"api/docs/upload"}, method={RequestMethod.POST})
    public ResultFile handleFileUpload(@RequestParam(value="files") MultipartFile[] files, @RequestParam(value="cfg") String cfgJSON) throws JsonProcessingException {
        String status = "";
        ResultFile result = new ResultFile(false, status);
        Gson gson = new Gson();
        Map cfg = (Map)gson.fromJson(cfgJSON, new HashMap().getClass());
        DocumentClass docClass = this.docClassService.getDocumentClass(cfg.get("documentClassName").toString(), new String[0]);
        if (docClass == null) {
            log.debug("DocClass " + cfg.get("documentClassName").toString() + " dont exist");
            return new ResultFile(false, "DocClass " + cfg.get("documentClassName").toString() + " don't exist");
        }
        Long documentClassId = docClass.getId();
        Map<Long, Object> newIdx = this.readIndexes(cfg);
        for (MultipartFile file : files) {
            if (!file.isEmpty()) {
                try (InputStream is = file.getInputStream();){
                    String customFileName;
                    DocumentDefinition definition = new DocumentDefinition();
                    definition.setDocumentClassId(documentClassId);
                    String string = customFileName = cfg.get("fileName") != null ? cfg.get("fileName").toString() : null;
                    if (customFileName == null || StringUtils.isBlank((String)customFileName)) {
                        definition.setFileName(file.getOriginalFilename());
                    } else {
                        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
                        int dLength = customFileName.length() - extension.length();
                        if (dLength < 0) {
                            definition.setFileName(customFileName + "." + extension);
                        } else {
                            String customExtension = customFileName.substring(dLength);
                            if (customExtension.equalsIgnoreCase(extension)) {
                                definition.setFileName(customFileName);
                            } else {
                                definition.setFileName(customFileName + "." + extension);
                            }
                        }
                    }
                    definition.setUserName(cfg.get("userName").toString());
                    definition.setInputStream(is);
                    definition.setProcessId(cfg.get("processId").toString());
                    definition.setActivityId(cfg.get("activityId").toString());
                    if (cfg.get("description") != null) {
                        definition.setDescription(cfg.get("description").toString());
                    }
                    definition.setIndexes(newIdx);
                    definition.setSaveAsNewVersion(cfg.get("saveAsNewVersion") == null ? false : (Boolean)cfg.get("saveAsNewVersion"));
                    AddDocumentResultMeta resultMeta = this.attachDocumentService.addDocumentWithMetaResult(definition);
                    this.documentClassActionService.executeProcessActions(resultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, definition.getProcessId(), definition.getActivityId(), resultMeta.getSavedAsNewVersion());
                    WfFile wfFile = resultMeta.getDocument().getFile();
                    wfFile.setVersion(null);
                    wfFile.setDocumentClass(null);
                    result.addWfFile(wfFile);
                    result.setSuccess(true);
                    status = status + "\nAdded " + file.getOriginalFilename();
                    result.setMessage(status);
                    continue;
                }
                catch (Exception e) {
                    log.debug("File" + file.getOriginalFilename() + " has not been uploaded: " + e.getClass().getSimpleName() + " : " + e.getMessage(), (Throwable)e);
                    status = status + "\nFile" + file.getOriginalFilename() + " has not been uploaded: " + e.getClass().getSimpleName() + " : " + e.getMessage();
                    result.setMessage(status);
                    result.setSuccess(false);
                    return result;
                }
            }
            log.debug("Uploaded file is empty");
            status = "Uploaded file is empty";
            result.setMessage(status);
        }
        return result;
    }

    @RequestMapping(value={"api/doc/updateIndecies"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult updateDocIndecies(@RequestParam String processId, @RequestParam Long fileId, @RequestParam(value="indexName[]") String[] indexNames, @RequestParam(value="indexValue[]") String[] indexValues) {
        HashMap<String, String> indeciesUpdate = new HashMap<String, String>();
        for (int i = 0; i < indexNames.length; ++i) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)indexNames[i])) continue;
            indeciesUpdate.put(indexNames[i], indexValues[i] == null ? "" : indexValues[i]);
        }
        RestResult restResult = new RestResult();
        WfDocument wfDocument = null;
        try {
            wfDocument = this.attachDocumentService.getWfDocument(fileId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (wfDocument == null) {
            restResult.setMessage("attachment.msg.docnotfind");
            restResult.setSuccess(false);
            return restResult;
        }
        restResult.setMessage("attachment.msg.docnotattach");
        List activitiesDocuments = this.activityDocumentService.getActivityDocuments(fileId, new String[]{"process"});
        for (ActivityDocument activityDocument : activitiesDocuments) {
            if (!activityDocument.getProcess().getProcessId().equals(processId)) continue;
            for (String indexName : indeciesUpdate.keySet()) {
                wfDocument.setIndexValue(indexName, indeciesUpdate.get(indexName));
            }
            this.attachDocumentService.updateDocument(wfDocument);
            restResult.setSuccess(true);
            restResult.setMessage(wfDocument.getId().toString());
            return restResult;
        }
        return restResult;
    }

    @RequestMapping(value={"api/doc/updateDescription"}, method={RequestMethod.POST})
    @ResponseBody
    public com.suncode.pwfl.web.support.ajax.RestResult updateDocDescription(@RequestParam String processId, @RequestParam Long fileId, @RequestParam(value="descriptionFile") String descriptionFile) {
        WfFile wfFile = this.attachDocumentService.getWfFile(fileId, new String[0]);
        if (wfFile == null) {
            return new com.suncode.pwfl.web.support.ajax.RestResult(false, "attachment.msg.docnotfind");
        }
        List activitiesDocuments = this.activityDocumentService.getActivityDocuments(fileId, new String[]{"process"});
        for (ActivityDocument activityDocument : activitiesDocuments) {
            if (!activityDocument.getProcess().getProcessId().equals(processId)) continue;
            wfFile.setDescription(descriptionFile);
            this.attachDocumentService.updateFile(wfFile);
            return new com.suncode.pwfl.web.support.ajax.RestResult(true, wfFile.getFileName());
        }
        return new com.suncode.pwfl.web.support.ajax.RestResult(false, "attachment.msg.docnotattach");
    }

    @RequestMapping(value={"api/docs/fileInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<FileInfo> getDocumentByFileId(@RequestParam(value="fileId") Long fileId, @RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        RestResult<FileInfo> restResult = new RestResult<FileInfo>();
        try {
            if (fileId < 1L || fileId == null) {
                restResult.setMessage("document.error.incorrectFileId");
                return restResult;
            }
            WfDocument wfDocument = this.attachDocumentService.getWfDocument(fileId);
            WfFile wfFile = this.attachDocumentService.getWfFile(fileId, "documentClass", "version");
            boolean isFileAttached = this.attachDocumentService.checkIfWfFileAttachedToActivity(processId, activityId, wfFile);
            if (isFileAttached) {
                FileInfo fileInfo = FileInfo.builder().id(wfFile.getId()).comment(wfDocument.getVersion().getComment()).documentId(wfDocument.getId()).name(wfFile.getFileName()).description(wfFile.getDescription()).uploader(wfFile.getUploader()).documentClassName(wfFile.getDocumentClass().getName()).documentClassId(wfDocument.getDocumentClassId()).expirationDate(wfDocument.getExpirationDate()).fileDate(wfFile.getFileDate()).filePath(wfFile.getPath()).fileSize(wfFile.getSize()).fileVersion(wfFile.getVersion().getVersion()).indexes(wfDocument.getIndexes()).build();
                restResult.setSuccess(true);
                restResult.setData(fileInfo);
            } else {
                restResult.setMessage("document.error.notAttached");
            }
        }
        catch (Exception e) {
            restResult.setMessage("document.error.notAttached");
            log.info("Document exception: " + e.getMessage());
        }
        return restResult;
    }

    private Map<Long, Object> readIndexes(Map<String, Object> cfg) {
        Map documentIndexes = (Map)cfg.get("indexes");
        HashMap<Long, Object> newIdx = new HashMap<Long, Object>();
        for (String IndexName : documentIndexes.keySet()) {
            if (StringUtils.isBlank((String)IndexName)) continue;
            newIdx.putAll(this.getDocumentClassIndexID(IndexName, documentIndexes.get(IndexName)));
        }
        return newIdx;
    }

    private Map<? extends Long, ? extends Object> getDocumentClassIndexID(String IndexName, Object value) {
        CustomService docClassIndexService = ServiceFactory.getCustomService(DocumentClassIndex.class, Long.class);
        List documentClassIndexList = docClassIndexService.getAll();
        HashMap<Long, Object> newIdx = new HashMap<Long, Object>();
        for (DocumentClassIndex documentClassIndex : documentClassIndexList) {
            if (!documentClassIndex.getName().equalsIgnoreCase(IndexName)) continue;
            newIdx.put(documentClassIndex.getId(), this.convert(value, documentClassIndex));
            return newIdx;
        }
        return null;
    }

    private Object convert(Object value, DocumentClassIndex documentClassIndex) {
        IndexType type = documentClassIndex.getType();
        if (value == null || value instanceof String && StringUtils.isBlank((String)value.toString())) {
            return null;
        }
        if (type == null) {
            throw new IllegalArgumentException("Nie podano typeName");
        }
        if (type == IndexType.DOUBLE) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof String) {
                String replaced = value.toString().replace(",", ".");
                if (!NumberUtils.isNumber((String)replaced)) {
                    throw new InvalidIndexValueException("Warto\u015b\u0107 indeksu typu nie jest liczb\u0105", value, documentClassIndex);
                }
                return Double.valueOf(replaced);
            }
            throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
        }
        if (type == IndexType.LONG) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Double) {
                return ((Double)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf(value.toString());
            }
            throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
        }
        if (type == IndexType.DATE) {
            if (value instanceof Date) {
                return value;
            }
            if (value instanceof String) {
                try {
                    return this.dateFormat.parse(value.toString());
                }
                catch (ParseException e) {
                    throw new InvalidIndexValueException("Niepoprawny format daty", value, documentClassIndex);
                }
            }
            throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
        }
        if (type == IndexType.DATETIME) {
            if (value instanceof Timestamp) {
                return value;
            }
            if (value instanceof String) {
                try {
                    return this.toTimestamp(value.toString());
                }
                catch (IllegalArgumentException | ParseException ex) {
                    throw new InvalidIndexValueException("Niepoprawny format timestamp", value, documentClassIndex);
                }
            }
            throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
        }
        if (type == IndexType.BOOLEAN) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                if (value.equals("on")) {
                    return Boolean.TRUE;
                }
                if (value.equals("off")) {
                    return Boolean.FALSE;
                }
                try {
                    return Boolean.valueOf(value.toString());
                }
                catch (Exception e) {
                    throw new InvalidIndexValueException("Niepoprawny format boolean: ", value, documentClassIndex);
                }
            }
            throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw new InvalidIndexValueException("Nieznany typ warto\u015bci indeksu warto\u015b\u0107", value, documentClassIndex);
    }

    private Timestamp toTimestamp(String text) throws ParseException {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(text);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(text);
            return new Timestamp(date.getTime());
        }
    }

    private List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }
}

