/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.configuration.controller;

import com.suncode.plugin.attachment.configuration.dto.ComboboxElementDto;
import com.suncode.plugin.attachment.configuration.enums.ElementParam;
import com.suncode.plugin.attachment.configuration.enums.ImageDestinationPage;
import com.suncode.plugin.attachment.configuration.enums.ImagePositionOnPage;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config/graphicFile"})
public class GraphicFileConfigController {
    @RequestMapping(value={"pageDestination"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboboxElementDto> getImageDestinationPageList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, ImageDestinationPage.values());
    }

    @RequestMapping(value={"positionOnPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboboxElementDto> getImagePositionOnPageList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.getElementList(query, start, limit, ImagePositionOnPage.values());
    }

    private CountedResult<ComboboxElementDto> getElementList(String query, Integer start, Integer limit, ElementParam[] enumList) {
        List elementsDto = Arrays.stream(enumList).map(ElementParam::build).collect(Collectors.toList());
        List filtered = elementsDto.stream().filter(dto -> {
            if (StringUtils.isBlank((String)query)) {
                return true;
            }
            if (StringUtils.isEmpty((String)dto.getName())) {
                return dto.getValue() != null && dto.getValue().toLowerCase().contains(query.toLowerCase());
            }
            return dto.getName().toLowerCase().contains(query.toLowerCase()) || dto.getValue() != null && dto.getValue().toLowerCase().contains(query.toLowerCase());
        }).collect(Collectors.toList());
        int totalFiltered = filtered.size();
        int fromIndex = Math.max(0, start);
        int toIndex = Math.min(fromIndex + limit, totalFiltered);
        List<Object> result = fromIndex >= totalFiltered ? new ArrayList() : filtered.subList(fromIndex, toIndex);
        return new CountedResult((long)totalFiltered, result);
    }
}

