PW.FormActions.create("attachment.actions.updateAttachmentAction", {

    dtButtonInit: function (button) {
        this.table = VariableSetService.get(button.getVariableSet().getId());
        this.settings = {};
        this.settings["columnFileId"] = this.get("columnFileId");
        this.settings["columnFileDate"] = this.get("columnFileDate");
        this.settings["columnFileName"] = this.get("columnFileName");
        this.settings["columnFileDescription"] = this.get("columnFileDescription");
        this.settings["columnFileDocumentClassName"] = this.get("columnFileDocumentClassName");
        this.settings["showIndexes"] = this.get("showIndexes");
        this.settings["checkRights"] = this.get("checkRights");
        this.settings["autoSelectFirst"] = this.get("autoSelectFirst");
        this.settings["refreshAfterAdd"] = this.get("refreshAfterAdd");
        this.settings["messageWarning"] = this.get("messageWarning");
        this.settings["documentClassName"] = this.get("documentClassName");
        this.settings["conditionFn"] = this.get("condition");
    },

    defaultActions: {
        dtButton: function () {
            this.updateAttachment(this.table);
        }
    },

    updateAttachment: function (table) {
        const selectedRow = VariableSetService.getSelected(table);
        if (selectedRow == null) {
            MessageService.show(this.settings["messageWarning"]);
            return;
        }

        const store = table.getStore();
        const rowIndex = store.isFiltered() ? store.snapshot.indexOf(selectedRow) : store.indexOf(selectedRow);

        if (this.settings["conditionFn"]) {
            this.setContextVariable("currentRow", rowIndex);
            if (!this.settings["conditionFn"].call()) {
                return;
            }
        }

        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: this.settings["showIndexes"],
            checkRights: this.settings["checkRights"],
            autoSelectFirst: this.settings["autoSelectFirst"],
            documentClassNameList: this.settings["documentClassName"],
            refreshAfterAdd: this.settings["refreshAfterAdd"],
            callback: (file) => {
                const fileId = selectedRow.data[this.settings["columnFileId"].getId()];
                const activityId = ActivityInfoService.getActivityId();
                const processId = ActivityInfoService.getProcessId();

                CUF.DocumentService.detachDocument(fileId, processId, activityId);

                if (this.settings["columnFileDate"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["columnFileDate"].getId(), new Date());
                }
                if (this.settings["columnFileId"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["columnFileId"].getId(), file.id);
                }
                if (this.settings["columnFileName"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["columnFileName"].getId(), file.fileName);
                }
                if (this.settings["columnFileDescription"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["columnFileDescription"].getId(), file.description);
                }
                if (this.settings["columnFileDocumentClassName"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["columnFileDocumentClassName"].getId(), file.documentClass.name);
                }
                FormService.save();
            }
        });
    }
});