/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.attachment.category.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/merge-pdf-files.js")
public class MergePDFFiles {
    private static final Logger log = LoggerFactory.getLogger(MergePDFFiles.class);
    private static final String ADMINISTRATOR_DEFAULT_USERNAME = "admin";
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("attachment.applications.MergePDFFiles")).name("attachment.applications.MergePDFFiles.name")).description("attachment.applications.MergePDFFiles.desc")).category(new Category[]{Categories.ATTACHMENT})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("documentClassName").name("attachment.applications.MergePDFFiles.param.documentClassName.name").description("attachment.applications.MergePDFFiles.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("outputFilename").name("attachment.applications.MergePDFFiles.param.outputFilename.name").description("attachment.applications.MergePDFFiles.param.outputFilename.desc").type((Type)Types.STRING).create()).parameter().id("outputFileDescription").name("attachment.applications.MergePDFFiles.param.outputFileDescription.name").description("attachment.applications.MergePDFFiles.param.outputFileDescription.desc").type((Type)Types.STRING).optional().create()).parameter().id("executeDocumentClassActions").name("attachment.applications.MergePDFFiles.param.executeDocumentClassActions.name").description("attachment.applications.MergePDFFiles.param.executeDocumentClassActions.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("outputFileId").name("attachment.applications.MergePDFFiles.param.outputFileId.name").description("attachment.applications.MergePDFFiles.param.outputFileId.desc").type((Type)Types.VARIABLE).create()).parameter().id("inputFileIdArray").name("attachment.applications.MergePDFFiles.param.inputFileIdArray.name").description("attachment.applications.MergePDFFiles.param.inputFileIdArray.desc").type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("addToProcess").name("attachment.applications.MergePDFFiles.param.addToProcess.name").description("attachment.applications.MergePDFFiles.param.addToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create();
    }

    public void set(ApplicationContext applicationContext, @Param String documentClassName, @Param String outputFilename, @Param String outputFileDescription, @Param boolean executeDocumentClassActions, @Param long[] inputFileIdArray, @Param Variable outputFileId, @Param boolean addToProcess) throws IOException {
        this.run(applicationContext, documentClassName, outputFilename, outputFileDescription, executeDocumentClassActions, inputFileIdArray, outputFileId, addToProcess);
    }

    public void execute(ApplicationContext applicationContext, @Param String documentClassName, @Param String outputFilename, @Param String outputFileDescription, @Param boolean executeDocumentClassActions, @Param long[] inputFileIdArray, @Param Variable outputFileId, @Param boolean addToProcess) throws IOException {
        this.run(applicationContext, documentClassName, outputFilename, outputFileDescription, executeDocumentClassActions, inputFileIdArray, outputFileId, addToProcess);
    }

    private void run(ApplicationContext applicationContext, String documentClassName, String outputFilename, String outputFileDescription, boolean executeDocumentClassActions, long[] inputFileIdArray, Variable outputFileId, boolean addToProcess) throws IOException {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[0]);
        Assert.notNull((Object)documentClass, (String)"Document class does not exist");
        byte[] bytes = this.mergePDFFiles(inputFileIdArray);
        String filename = this.prepareOutputFilename(outputFilename);
        String processId = "";
        if (addToProcess) {
            processId = applicationContext.getProcessId();
        }
        DocumentDefinition documentDefinition = this.createDocumentDefinition(documentClass.getId(), filename, outputFileDescription, bytes, processId);
        WfDocument addedDocument = this.documentService.addDocument(documentDefinition);
        if (executeDocumentClassActions) {
            this.documentClassActionService.executeArchiveActions(addedDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        }
        outputFileId.setValue((Object)addedDocument.getFile().getId());
    }

    private byte[] mergePDFFiles(long[] fileIds) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PDFMergerUtility mergerUtility = new PDFMergerUtility();
            mergerUtility.setDestinationStream((OutputStream)outputStream);
            for (long fileId : fileIds) {
                File file = new File(this.fileService.getFile(Long.valueOf(fileId), new String[0]).getFullPath());
                mergerUtility.addSource(file);
            }
            mergerUtility.mergeDocuments(null);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private DocumentDefinition createDocumentDefinition(long documentClassId, String filename, String description, byte[] documentBytes, String processId) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(Long.valueOf(documentClassId));
        documentDefinition.setFileName(filename);
        documentDefinition.setUserName(ADMINISTRATOR_DEFAULT_USERNAME);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(documentBytes));
        documentDefinition.setSaveAsNewVersion(false);
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            documentDefinition.setProcessId(processId);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            documentDefinition.setDescription(description);
        }
        return documentDefinition;
    }

    private String prepareOutputFilename(String outputFilename) {
        return StringUtils.endsWithIgnoreCase((CharSequence)outputFilename, (CharSequence)".pdf") ? outputFilename : outputFilename.concat(".pdf");
    }
}

