PW.FormActions.create("table-update-attachment", {
    init: function () {
        this.settings = {};
        this.settings["column-file-id"] = this.get("column-file-id");
        this.settings["column-file-date"] = this.get("column-file-date");
        this.settings["column-file-name"] = this.get("column-file-name");
        this.settings["column-file-descripton"] = this.get("column-file-descripton");
        this.settings["column-file-class-name"] = this.get("column-file-class-name");
        this.settings["show-indexes"] = this.get("show-indexes");
        this.settings["check-rights"] = this.get("check-rights");
        this.settings["auto-select-first"] = this.get("auto-select-first");
        this.settings["refresh-after-add"] = this.get("refresh-after-add");
        this.settings["msg-warning"] = this.get("msg-warning");
        this.settings["doc-class-name"] = this.get("doc-class-name");
        this.settings["condition-fn"] = this.get("condition");
    },
    dtButtonInit: function (button) {
        this.table = VariableSetService.get(button.getVariableSet().getId());
    },
    variableSetInit: function (variableSet) {
        const table = VariableSetService.get(variableSet.getId());
        const buttonName = this.get("button-name");
        const iconName = this.get("icon-name");

        VariableSetService.addBottomToolbarButton(
            table, {
                itemId: "updateAttachment",
                iconCls: "silk-" + iconName,
                text: buttonName,
                handler: () => this.switchAttachment(table)
            });
    },
    defaultActions: {
        dtButton: function () {
            this.switchAttachment(this.table);
        }
    },
    switchAttachment: function (table) {
        const selectedRow = VariableSetService.getSelected(table);
        if (selectedRow == null) {
            MessageService.show(this.settings["msg-warning"]);
            return;
        }

        const store = table.getStore();
        const rowIndex = store.isFiltered() ? store.snapshot.indexOf(selectedRow) : store.indexOf(selectedRow);

        if (this.settings["condition-fn"]) {
            this.setContextVariable("current-row", rowIndex);
            if (!this.settings["condition-fn"].call()) {
                return;
            }
        }

        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: this.settings["show-indexes"],
            checkRights: this.settings["check-rights"],
            autoSelectFirst: this.settings["auto-select-first"],
            documentClassNameList: this.settings["doc-class-name"],
            refreshAfterAdd: this.settings["refresh-after-add"],
            callback: (file) => {
                const fileId = selectedRow.data[this.settings["column-file-id"].getId()];
                const activityId = ActivityInfoService.getActivityId();
                const processId = ActivityInfoService.getProcessId();

                CUF.DocumentService.detachDocument(fileId, processId, activityId);

                if (this.settings["column-file-date"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["column-file-date"].getId(), new Date());
                }
                if (this.settings["column-file-id"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["column-file-id"].getId(), file.id);
                }
                if (this.settings["column-file-name"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["column-file-name"].getId(), file.fileName);
                }
                if (this.settings["column-file-descripton"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["column-file-descripton"].getId(), file.description);
                }
                if (this.settings["column-file-class-name"]) {
                    VariableSetService.setValue(table, rowIndex, this.settings["column-file-class-name"].getId(), file.documentClass.name);
                }

                FormService.save();
            }
        });
    }
});