PWE.integrationComponent.registerFormAction('attachments.table-paste-image', {
    apiVersion: 2,
    buildForm: function (form, options) {
        var indexTable = null;
        form.addField("msgDocAttach");
        form.addField("msgNoImageInClibboard");
        form.addField("msgSuccessAdd");
        form.addLabel(Attachment.t("action.buttons-for-attachments-in-column.document-info"));
        form.addField("columnFileId");
        form.addCheckbox({
            id: "checkboxColumn",
            name: Attachment.t("action.buttons-for-attachments-in-column.more-document-info"),
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("columnDocId");
                        form.show("columnFileName");
                        form.show("columnFileDate");
                        form.show("columnFileDescripton");
                        form.show("columnFileClassName");
                    } else {
                        form.hide("columnDocId");
                        form.hide("columnFileName");
                        form.hide("columnFileDate");
                        form.hide("columnFileDescripton");
                        form.hide("columnFileClassName");
                    }
                }
            }
        })
        form.addField({
            id: "columnDocId",
            hidden: true
        });
        form.addField({
            id: "columnFileName",
            hidden: true
        });
        form.addField({
            id: "columnFileDate",
            hidden: true
        });
        form.addField({
            id: "columnFileDescripton",
            hidden: true
        });
        form.addField({
            id: "columnFileClassName",
            hidden: true
        });
        form.addField({
            id: "showAddDocForm",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("docClassListName");
                        form.show("showIndexes");
                        form.show("checkRights");
                        form.show("autoSelectFirst");
                        form.hide("documentClassName");
                        form.hide("indexTable");
                        form.hide("saveAsNewVersion");
                    } else {
                        form.hide("docClassListName");
                        form.hide("showIndexes");
                        form.hide("checkRights");
                        form.hide("autoSelectFirst");
                        form.show("documentClassName");
                        form.show("indexTable");
                        form.show("saveAsNewVersion");
                    }
                }
            }
        })
        Attachment.addComboboxClassList("docClassListName", null, form, null)
        form.addField({
            id: "showIndexes",
        });
        form.addField({
            id: "checkRights",
        });
        form.addField({
            id: "autoSelectFirst",
        });
        Attachment.addComboboxClassList("documentClassName", {
            change: function (value) {
                var pos = form.getFieldPosition("indexesName");
                form.removeField("indexesName");
                if (form.hasVariableValue("documentClassName") || form.hasFunctionValue("documentClassName")) {
                    indexTable.addField({
                        id: "indexesName",
                    }, pos)
                } else {
                    Attachment.addComboboxClassIndexList("indexesName", value, null, indexTable, 0);
                }
                Attachment.resetColumnValue("indexesName", form);
            }
        }, form, null)
        form.addField({
            id: "saveAsNewVersion",
            hidden: true
        });
        indexTable = form.addTable({
            id: "indexTable",
            name: Attachment.t("dpwe.indexTable.name"),
            description: Attachment.t("dpwe.indexTable.desc"),
            hidden: true
        })
        if (form.hasVariableValue("documentClassName") || form.hasFunctionValue("documentClassName")) {
            indexTable.addField({
                id: "indexesName",
            })
        } else {
            Attachment.addComboboxClassIndexList("indexesName", form.getValue("documentClassName"), null, indexTable, 0);
        }
        indexTable.addField({
            id: "indexesValue",
        });
        if (!form.getValue("showAddDocForm", false)) {
            form.hide("docClassListName");
            form.hide("showIndexes");
            form.hide("checkRights");
            form.hide("autoSelectFirst");
            form.show("documentClassName");
            form.show("indexTable");
            form.show("saveAsNewVersion");
        } else {
            form.show("docClassListName");
        }

    }
});
