PWE.integrationComponent.registerApplication("attachment.applications.CompressPdfFiles", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
    validateForm: (api) => validateForm(api)
});

PWE.integrationComponent.registerVariablesSetter("attachment.applications.CompressPdfFiles", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
    validateForm: (api) => validateForm(api)
});

function buildForm(form) {
    form.addField("fileIds");
    form.addField("compressionThresholdMB");
    form.addField({
        id: "saveAsNewVersion",
        listeners: {
            change: function(value) {
                if (!value) {
                    toggleFieldWhenSaveAsNewVersionIsFalse(form);
                } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
                    toggleFieldWhenSaveAsNewVersionIsFunctionOrVariable(form);
                } else {
                    toggleFieldWhenSaveAsNewVersionIsTrue(form);
                }
            }
        }
    });
    Attachment.addComboboxClassList("targetDocumentClassName", null, form, null);
    form.addField("addDocumentToProcess");
    form.addField("executeArchiveActions");
    afterFormLoad(form);
}

function afterFormLoad(form) {
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldWhenSaveAsNewVersionIsTrue(form);
    }
}

function toggleFieldWhenSaveAsNewVersionIsFalse(form) {
    form.setNotEmpty("targetDocumentClassName", true);
    form.show("targetDocumentClassName");
    form.show("addDocumentToProcess");
    form.show("executeArchiveActions");
}

function toggleFieldWhenSaveAsNewVersionIsFunctionOrVariable(form) {
    form.setNotEmpty("targetDocumentClassName", false);
    form.show("targetDocumentClassName");
    form.show("addDocumentToProcess");
    form.show("executeArchiveActions");
}

function toggleFieldWhenSaveAsNewVersionIsTrue(form) {
    form.setNotEmpty("targetDocumentClassName", false);
    form.hide("targetDocumentClassName");
    form.hide("addDocumentToProcess");
    form.hide("executeArchiveActions");
}

function validateForm(api) {
    let thresholdValue = api.getValue("compressionThresholdMB");
    if (!thresholdValue || thresholdValue <= 0) {
        api.markError("compressionThresholdMB");
        api.showErrorMessage(Attachment.t("attachment.applications.CompressPdfFiles.compressionThresholdMB.errorMessage"));
        return false
    }
}
