PW.FormActions.create('attachment.update-indecies.action', {

    variableSetInit: function (table) {
        this.tableId = table.getId();
        this.tableSet = VariableSetService.get(this.tableId);
        this.columnIDs = [];
        const me = this;
        jQuery(this.get('updateColumn')).each(function (index, item) { me.columnIDs.push(item.getId()); })
    },

    enable: function () {

    },

    disable: function () {
    },

    defaultActions: {
        button: function (button) { },
        variable: function (variable, newValue, oldValue) { },
        variableSet: function (variableSet, added, updated, removed) {
            if (updated.length > 0) {
                for (let updateIndex = 0; updateIndex < updated.length; updateIndex++) {
                    let currentRow = updated[updateIndex].index;
                    this.setContextVariable("currentRow", currentRow);
                    if( this.processRowCondition(currentRow) )
                    {
                        let fileId = VariableSetService.getValue(this.tableSet, currentRow, this.get('columnFileId').getId());
                        if (fileId) {
                            for (let indexColumn = 0; indexColumn < updated[updateIndex].changes.length; indexColumn++) {
                                if (this.columnIDs.includes(updated[updateIndex].changes[indexColumn])) {
                                    FormService.mask();
                                    let indexName = this.get('indexName');
                                    let indexValue = this.get('indexValue');

                                    if (indexName.length != indexValue.length) {
                                        Logger.error('Index parameters have different lengths \tindexName :' + indexName.length + '\tindexValue :' + indexValue.length);
                                        return;
                                    }
                                    for(let i=0;i<indexName.length;i++){if(!indexName[i])indexName[i]='';}
                                    for(let i=0;i<indexValue.length;i++){if(!indexValue[i])indexValue[i]='';}
                                    jQuery.ajax({
                                        url: 'plugin/com.suncode.plugin-attachment/api/doc/updateIndecies',
                                        type: "POST",
                                        async: false,
                                        data: {
                                            processId: processId,
                                            fileId: fileId,
                                            indexName: indexName,
                                            indexValue: indexValue
                                        },
                                        success: function (data) {
                                            if (!data.success) {
                                                Logger.error(Attachment.t(data.message));
                                                Logger.error("FileId\t" + fileId);
                                                MessageService.showFailure(Attachment.t(data.message));
                                            }
                                            FormService.unmask();
                                        },
                                        error: function (error) {
                                            FormService.unmask();
                                            MessageService.showFailure(Attachment.t("attachment.msg.server.error"));
                                        }
                                    });
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    },

    processRowCondition: function(rowIndex) {
        if (this.get("condition")) {
            return this.get("condition").call();
        }
        return true;
    }
});
