PW.FormActions.create('table-add-attachment', {

    init: function() {
        this.isDtButton = false;
        this.settings = {};

        this.settings["column-file-id"] = this.get("column-file-id");
        this.settings["column-doc-id"] = this.get("column-doc-id");
        this.settings["column-file-date"] = this.get("column-file-date");
        this.settings["column-file-name"] = this.get("column-file-name");
        this.settings["column-file-descripton"] = this.get("column-file-descripton");
        this.settings["column-file-class-name"] = this.get("column-file-class-name");
        this.settings["show-indexes"] = this.get("show-indexes");
        this.settings["check-rights"] = this.get("check-rights");
        this.settings["auto-select-first"] = this.get("auto-select-first");
        this.settings["refresh-after-add"] = this.get("refresh-after-add");
        this.settings["add-new-row"] = this.get("add-new-row");

        this.classesList = this.get("doc-class-name");
    },

    variableSetInit: function (variableSet) {
        this.buttonName = this.get("button-name");
        this.iconName = this.get("icon-name");
        this.table = VariableSetService.get(variableSet.getId());
    },

    dtButtonInit: function (button) {
        this.isDtButton = true;
        this.table = VariableSetService.get(button.getVariableSet().getId());
    },

    defaultActions: {
        dtButton: function(){
            this.addButtonFunc(this.table, this.settings, this.classesList);
        }
    },

    enable: function () {
        if (!this.isDtButton) {
            let me = this;
            VariableSetService.addBottomToolbarButton(
                this.table, {
                    itemId: 'addAttachment',
                    iconCls: "silk-" + this.iconName,
                    text: this.buttonName,
                    handler: function () {
                        me.addButtonFunc(me.table, me.settings, me.classesList);
                    }
                });
        }
    },

    disable: function () {
        if (!this.isDtButton) {
            VariableSetService.removeBottomToolbarButton(this.table, 'addAttachment');
        }
    },

    addButtonFunc: function (table, settings, fileClasses) {
        var selectedRow = VariableSetService.getSelected(table);
        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: settings["show-indexes"],
            checkRights: settings["check-rights"],
            autoSelectFirst: settings["auto-select-first"],
            documentClassNameList: fileClasses,
            refreshAfterAdd: settings["refresh-after-add"],
            callback: function (file) {
                if (settings["add-new-row"] == true || selectedRow == null) {
                    var row = new Object();
                    if (settings["column-file-date"]) {
                        row[settings["column-file-date"].getId()] = new Date();
                    }
                    if (settings["column-file-id"]) {
                        row[settings["column-file-id"].getId()] = file.id;
                    }
                    if (settings["column-doc-id"]) {
                        var docIdTemp = -1;
                        // console.log('przed '+filetemp);
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                docIdTemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                                ;
                            }
                        });
                        row[settings["column-doc-id"].getId()] = docIdTemp;
                        //row[settings["column-doc-id"].getId()]=file.id;
                    }
                    if (settings["column-file-name"]) {
                        row[settings["column-file-name"].getId()] = file.fileName;
                    }
                    if (settings["column-file-descripton"]) {
                        row[settings["column-file-descripton"].getId()] = file.description;
                    }
                    if (settings["column-file-class-name"]) {
                        row[settings["column-file-class-name"].getId()] = file.documentClass.name;
                    }
                    VariableSetService.addRow(table, false, row);
                } else {

                    var indexRow = VariableSetService.getRowIndex(table, selectedRow);
                    if (settings["column-file-date"]) {
                        VariableSetService.setValue(table, indexRow, settings["column-file-date"].getId(), new Date());
                    }
                    if (settings["column-file-id"]) {
                        VariableSetService.setValue(table, indexRow, settings["column-file-id"].getId(), file.id);
                    }
                    if (settings["column-doc-id"]) {
                        var filetemp = -1;
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                filetemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                                ;
                            }
                        });
                        //  console.log('po ax '+filetemp);
                        VariableSetService.setValue(table, indexRow, settings["column-doc-id"].getId(), filetemp);
                    }
                    if (settings["column-file-name"]) {
                        VariableSetService.setValue(table, indexRow, settings["column-file-name"].getId(), file.fileName);
                    }
                    if (settings["column-file-descripton"]) {
                        VariableSetService.setValue(table, indexRow, settings["column-file-descripton"].getId(), file.description);
                    }
                    if (settings["column-file-class-name"]) {
                        VariableSetService.setValue(table, indexRow, settings["column-file-class-name"].getId(), file.documentClass.name);
                    }
                    VariableSetService.save(table);
                }
                // Dołączono dokument, zapisujemy więc tabele dyn., żeby po odświeżeniu strony informacja o tym nam nie zniknęła.
                var formService = ServiceFactory.getFormService();
                formService.save();
            }
        });
    }
});