/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.services;

import com.plusmpm.util.Authorization;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.attachment.dto.FileInfo;
import com.suncode.plugin.attachment.services.AttachDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.security.rights.DocumentRightService;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AttachDocumentServiceImpl
implements AttachDocumentService {
    private static final Logger log = LoggerFactory.getLogger(AttachDocumentServiceImpl.class);
    public static final String ADMINISTRATOR_DEFAULT_USERNAME = "admin";
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentRightService documentRightService;
    @Autowired
    private ActivityDocumentService activityDocumentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Override
    public WfFile getWfFile(Long fileId, String ... joins) {
        try {
            return this.fileService.getFile(fileId, joins);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public AddDocumentResultMeta addDocumentWithMetaResult(DocumentDefinition definition) {
        return this.documentService.addDocumentWithMetaResult(definition);
    }

    @Override
    public void updateFile(WfFile wfFile) {
        this.fileService.updateFile(wfFile);
    }

    @Override
    public WfDocument getWfDocument(Long fileId) {
        return this.documentService.getDocument(fileId);
    }

    @Override
    public void updateDocument(WfDocument wfDocument) {
        this.documentService.updateDocument(wfDocument);
    }

    @Override
    public FileInfo buildFileInfo(WfFile wfFile) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(wfFile.getId());
        fileInfo.setName(wfFile.getFileName());
        fileInfo.setDescription(wfFile.getDescription());
        fileInfo.setUploader(wfFile.getUploader());
        fileInfo.setFileDate(wfFile.getFileDate());
        return fileInfo;
    }

    @Override
    public WfFile getNewestWfFile(Long fileId, String ... joins) {
        try {
            return this.fileService.getFile(fileId, joins).getVersion().getNewestFile();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean checkIfWfFileAttachedToActivity(String processId, String activityId, WfFile wfFile) {
        if (wfFile == null) {
            return false;
        }
        Long newestFileId = wfFile.getVersion().getNewestFile().getId();
        List wfDocList = this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[0]);
        return wfDocList.stream().anyMatch(doc -> doc.getFile().getId() == newestFileId.longValue());
    }

    @Override
    public boolean checkFileVersionsUploader(final Long fileId, final String currentUser) {
        final ArrayList<Boolean> allowDetach = new ArrayList<Boolean>();
        allowDetach.add(true);
        PlatformTransactionManager hibernateTransactionManager = TransactionManagerFactory.getHibernateTransactionManager();
        TransactionTemplate template = new TransactionTemplate(hibernateTransactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                WfFile selectedWfFile = AttachDocumentServiceImpl.this.fileService.getFile(fileId, new String[]{"documentClass", "version.newestFile"});
                if (!currentUser.equals(selectedWfFile.getUploader())) {
                    allowDetach.clear();
                    allowDetach.add(false);
                }
                WfFile wfFile = selectedWfFile.getVersion().getNewestFile();
                String uploader = wfFile.getUploader();
                while (!wfFile.equals(selectedWfFile)) {
                    if (!currentUser.equals(uploader)) {
                        allowDetach.clear();
                        allowDetach.add(false);
                    }
                    wfFile = wfFile.getVersion().getParentFile();
                    uploader = wfFile.getUploader();
                }
            }
        });
        return (Boolean)allowDetach.get(0);
    }

    @Override
    public boolean hasRightsToReadFile(String userName, Long fileId, String processRightKey) {
        return this.documentRightService.hasRightsToReadFile(userName, fileId, processRightKey);
    }

    @Override
    public boolean hasRightsToModifyFile(String userName, Long fileId) {
        WfFile wfFile = this.fileService.getFile(fileId, new String[]{"documentClass"});
        Long docClassId = wfFile.getDocumentClass().getId();
        return Authorization.hasRightsToModifyFile((String)userName, (Long)docClassId);
    }

    @Override
    public boolean hasRightsToDeleteFile(String userName, Long fileId) {
        WfFile wfFile = this.fileService.getFile(fileId, new String[]{"documentClass"});
        Long docClassId = wfFile.getDocumentClass().getId();
        int right = Authorization.checkRight((String)("System.archive.docclasses." + docClassId + ".delete"), (String)userName, (boolean)false, (boolean)false);
        return right == 0;
    }

    @Override
    public boolean hasRightsToDetachFile(String userName, Long fileId, String processId, String activityId) {
        ActivityDocument activityDocument = this.activityDocumentService.getActivityDocument(fileId.longValue(), activityId);
        if (activityDocument == null) {
            activityDocument = this.activityDocumentService.getOnlyProcessDocument(fileId.longValue(), processId);
        }
        if (activityDocument == null) {
            log.info("File " + fileId + "is not attached to a task or process - it cannot be detached. This is probably an older version of the document.");
            return false;
        }
        WfFile wfFile = this.fileService.getFile(fileId, new String[]{"documentClass"});
        DocumentClass docClass = wfFile.getDocumentClass();
        boolean hasRights = Authorization.hasRightsToDetachDocument((ActivityDocument)activityDocument, (String)userName, (Long)docClass.getId());
        if (!hasRights) {
            log.info("User [" + userName + "] has no detach rights to document class: " + docClass.getName());
            return false;
        }
        return true;
    }

    @Override
    public void addFileToArchive(WfFile originalFile, String targetDocumentClassName, byte[] fileContent, boolean saveAsNewVersion, boolean addDocumentToProcess, boolean executeArchiveActions, String processId, String activityId) throws Exception {
        DocumentDefinition documentDefinition = this.createDocumentDefinition(originalFile.getFileName(), targetDocumentClassName, fileContent, saveAsNewVersion);
        if (Boolean.TRUE.equals(saveAsNewVersion)) {
            this.addFileAsNewVersion(documentDefinition, originalFile.getId());
        } else {
            WfDocument document = this.documentService.addDocument(documentDefinition);
            if (Boolean.TRUE.equals(addDocumentToProcess)) {
                this.documentService.attachDocumentToProcess(document, ADMINISTRATOR_DEFAULT_USERNAME, processId, activityId);
            }
            if (Boolean.TRUE.equals(executeArchiveActions)) {
                this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
        }
    }

    @Override
    public boolean isDocumentPDFFormat(String fileName) {
        return FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("pdf");
    }

    private DocumentDefinition createDocumentDefinition(String fileName, String targetDocumentClassName, byte[] fileContent, Boolean saveAsNewVersion) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setFileName(fileName);
        documentDefinition.setUserName(ADMINISTRATOR_DEFAULT_USERNAME);
        if (Boolean.FALSE.equals(saveAsNewVersion)) {
            documentDefinition.setDocumentClassId(this.getDocumentClassId(targetDocumentClassName));
        }
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(fileContent));
        return documentDefinition;
    }

    private void addFileAsNewVersion(DocumentDefinition documentDefinition, Long fileId) throws Exception {
        String currentDocState = this.fileService.getVersionForFile(fileId).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(fileId);
        }
        this.fileService.checkOut(fileId, ADMINISTRATOR_DEFAULT_USERNAME);
        this.fileService.checkIn(documentDefinition, fileId, "");
    }

    private Long getDocumentClassId(String documentClassName) {
        return this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId();
    }
}

