PW.FormActions.create('buttons-for-attachments-in-column', {

    variableSetInit: function (table) {
        this.table = table;
        this.tableId = table.getId();
        this.tableSet = VariableSetService.get(this.tableId);
        this.errorFileId = "ERROR_FILEID";
        var me = this;
        this.idComponent = 'attach-buttons-' + Math.floor(Math.random() * 1000);
        jQuery('body').click(function () {
            jQuery('.menu-' + me.idComponent).css('visibility', 'hidden');
        });
    },

    enable: function () {
        this.initButtonFun();
        var me = this;
        var table = VariableSetService.get(this.tableId);

        VariableSetService.addRenderer(table, function (value, data, column, metaData) {
            if (metaData.row >= me.table.getRecords().length) {
                return "";
            }
            metaData.encode = false;
            me.setContextVariable("currentRow", metaData.row);

            var div = jQuery("<div/>");
            var divButtonsContainer = jQuery("<div/>");
            var buttonsContainerId = Ext4.id();
            divButtonsContainer.attr('id', buttonsContainerId);
            divButtonsContainer.attr('style', 'text-align:center');
            div.append(divButtonsContainer);

            //ErrorButton
            if (me.get("column").getValueAt(metaData.row) == me.errorFileId) {
                var button = me.buildTemplateIconButton(
                    Attachment.t("attachment.buttons-for-attachments-in-column.doc-not-found"),
                    me.errorButtonClickFn(metaData.row),
                    me.getIconClass("exclamation")
                );
                divButtonsContainer.append(button);
            } else if (me.get("display-method") == "CONTEXT-MENU") {

                //TODO: kiepskie rozwiązanie, ale w aby zrobic to dobrze, trzeba przepisac cały kod.
                // Renderer nie powinien odpytywać serwer. Powinien renderować tylko wczesniej przygotowane
                // dane tekstowe np.: [SHOW][ADD][REMOVE]
                setTimeout(() => {
                    me.createMenu(me, buttonsContainerId, metaData.row)
                }, 0);

            } else {
                //TODO: createButtonsPanel jest Async. Do poprawy
                me.createButtonsPanel(me, buttonsContainerId, metaData.row);
            }

            return div.html();
        }, [this.get("column").getId()]);
    },

    buildTemplateIconButton: function (btnTooltip, onClickFunction, iconClass) {

        let button = jQuery("<a/>");
        button.addClass("x4-btn")
        button.addClass("x4-btn-default-small-icon-text-left")
        button.css("line-height", "12px");
        button.css("padding", "0px");
        button.on("click", onClickFunction);

        let span = jQuery("<span/>");
        span.addClass("x4-btn-inner-center");
        span.css("padding-left", "12px");
        span.css("padding-right", "12px");
        span.addClass(iconClass);

        button.append(span);
        return button;
    },

    disable: function () {
        VariableSetService.removeRenderers(this.tableSet, [this.get("column").getId()]);
    },

    isDocumentAdded: function () {
        var fileIdHolder = this.get('column-file-id');
        if (!fileIdHolder) {
            return false;
        }
        var fileId = fileIdHolder.getValueAt(this.contextVariables.get("currentRow"));
        return Ext4.isNumeric(fileId);
    },

    shouldDisplayAddButton: function () {
        return !(isHistory || this.isDocumentAdded() || this.get('hide-add-btn'));
    },

    shouldDisplayShowButton: function () {
        return this.isDocumentAdded() && !this.get('hide-show-btn');
    },

    shouldDisplayDetachButton: function () {
        return !isHistory && this.isDocumentAdded() && !this.get('hide-detach-btn');
    },

    shouldDisplayDownloadButton: function () {
        return !isHistory && this.isDocumentAdded() && !this.get('hide-download-btn');
    },

    createButtonsPanel: function (me, buttonsContainerId, row) {
        var fileId = VariableSetService.getValue(me.tableSet, row, me.get("column-file-id").getId());

        var show = me.shouldDisplayShowButton();
        var add = me.shouldDisplayAddButton();
        var detach = me.shouldDisplayDetachButton();
        var download = me.shouldDisplayDownloadButton();
        var deleteFromArchive = me.get("deleteFromArch");

        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-attachment/api/docs/getOptions/',
            method: 'GET',
            data: {
                processId: processId,
                fileId: fileId,
                showOption: show,
                addOption: add,
                detachOption: detach,
                downloadOption: download,
                deleteFromArchive: deleteFromArchive
            },
            success: function (response) {
                var buttons = me.arrangeOptions(me, response, false, row);
                me.createButtonGroup(me, buttonsContainerId, buttons);
            },
            error: function (message) {
                Logger.error(message);
            }
        });
    },

    createButtonGroup: function (me, buttonsContainerId, buttons) {

        buttons.forEach(function (button) {
            me.buildTemplateIconButton(
                button.tooltip,
                button.handler,
                me.getIconClass(button.iconCls)
            ).appendTo("#" + buttonsContainerId);
        })
    },

    getIconClass(iconName) {
        return 'silk-' + iconName;
    },

    changeSystemCellPadding: function (buttonsContainerId) {
        jQuery('#' + buttonsContainerId).parent().css({"padding-top": "1px", "padding-bottom": "1px"});
    },

    clickShow: function (me, row) {
        me.setContextVariable("currentRow", row);
        let fileId = VariableSetService.getValue(me.tableSet, row, me.get('column-file-id').getId());
        let newestVersion = me.get("newest-file-version");
        Attachment.showDocument(fileId, newestVersion);
    },

    clickAdd: function (me, row) {
        me.setContextVariable("currentRow", row);
        var cfg = me.buildAddCfg(row);
        jQuery(me).data('cfg', cfg);
        Attachment.addDocument(me);
    },

    clickDetach: function (me, row) {
        me.setContextVariable("currentRow", row);
        var fileId = VariableSetService.getValue(me.tableSet, row, me.get('column-file-id').getId());
        var cfg = this.buildDetachCfg(fileId, row);
        jQuery(me).data('cfg', cfg);
        if (me.get("deleteFromArch")) {
            Attachment.deleteDocument(me);
        } else {
            Attachment.detachDocument(me);
        }
    },

    clickDownload: function (me, row) {
        me.setContextVariable("currentRow", row);
        var cfg = this.buildTemplateCfg(row);
        var fileId = VariableSetService.getValue(me.tableSet, row, me.get('column-file-id').getId());
        jQuery(me).data('cfg', cfg);
        Attachment.downloadDocument(me, fileId);
    },

    clickSave: function (me, row) {
        me.setContextVariable("currentRow", row);
        var cfg = this.buildTemplateCfg(row);
        var fileid = VariableSetService.getValue(me.tableSet, row, me.get('column-file-id').getId());
        jQuery(me).data('cfg', cfg);
        Attachment.saveDocument(me, fileid);
    },

    clickCancel: function (me, row) {
        me.setContextVariable("currentRow", row);
        var cfg = this.buildTemplateCfg(row);
        var fileid = VariableSetService.getValue(me.tableSet, row, me.get('column-file-id').getId());
        jQuery(me).data('cfg', cfg);
        Attachment.cancelDocument(me, fileid);
    },

    eventShowMenu: function (event, row) {
        event.stopPropagation();
        event.preventDefault();
        var me = this;
        me.setContextVariable("currentRow", row);

        var show = me.shouldDisplayShowButton();
        var add = me.shouldDisplayAddButton();
        var detach = me.shouldDisplayDetachButton();
        var download = me.shouldDisplayDownloadButton();
        var deleteFromArchive = me.get("deleteFromArch");

        var fileId = VariableSetService.getValue(me.tableSet, row, me.get("column-file-id").getId());

        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-attachment/api/docs/getOptions/',
            method: 'GET',
            data: {
                processId: processId,
                fileId: fileId,
                showOption: show,
                addOption: add,
                detachOption: detach,
                downloadOption: download,
                deleteFromArchive: deleteFromArchive
            },
            success: function (response) {
                var items = me.arrangeOptions(me, response, true, row);
                items.forEach(function (item) {
                    item.iconCls = me.getIconClass(item.iconCls);
                })

                Ext4.create('Ext4.menu.Menu', {
                    autoWidth: true,
                    renderTo: Ext4.getBody(),
                    items: items
                }).showAt(event.pageX, event.pageY);
            },
            error: function (message) {
                Logger.error(message);
            }
        });
    },

    arrangeOptions: function (me, options, showInContextMenu, row) {
        var optionNames = [];
        for (var k in options) {
            if (options[k]) {
                optionNames.push(k);
            }
        }
        var menuItems = [];
        for (var item of optionNames) {
            var menuItem = {};

            switch (item) {
                case "showOption":
                    this.setMenuItemProperties(menuItem, "show", () => me.clickShow(me, row));
                    break;
                case "addOption":
                    this.setMenuItemProperties(menuItem, "add", () => me.clickAdd(me, row));
                    break;
                case "detachOption":
                    this.setMenuItemProperties(menuItem, "detach", () => me.clickDetach(me, row));
                    break;
                case "downloadOption":
                    this.setMenuItemProperties(menuItem, "download", () => me.clickDownload(me, row));
                    break;
                case "saveOption":
                    this.setMenuItemProperties(menuItem, "save", () => me.clickSave(me, row));
                    break;
                case "cancelOption":
                    this.setMenuItemProperties(menuItem, "cancel", () => me.clickCancel(me, row));
                    break;
            }
            menuItems.push(menuItem);
        }
        return menuItems;
    },

    setMenuItemProperties: function (menuItem, name, handlerFn) {
        menuItem.text = this.get(name + "-button-name");
        menuItem.tooltip = this.get(name + "-button-name");
        menuItem.iconCls = this.get(name + "-icon-name");
        menuItem.handler = handlerFn;
    },

    setErrorButton: function (message, me, row) {
        var menuItem = {};
        menuItem.tooltip = Attachment.t(message);
        menuItem.iconCls = me.getIconClass("exclamation");
        menuItem.handler = function () {
            var data = me.buildTemplateCfg(row);
            var table = VariableSetService.get(data.tableID);
            me.clearRow(data, table);
        }
        return menuItem;
    },

    clearRow: function (data, table) {
        if (data.columnMenu) {
            VariableSetService.setValue(table, data.currentRow, data.columnMenu, '');
        }
        if (data.columnFileDate) {
            VariableSetService.setValue(table, data.currentRow, data.columnFileDate, null);
        }
        if (data.columnFileId) {
            VariableSetService.setValue(table, data.currentRow, data.columnFileId, null);
        }
        if (data.columnDocId) {
            VariableSetService.setValue(table, data.currentRow, data.columnDocId, null);
        }
        if (data.columnFileName) {
            VariableSetService.setValue(table, data.currentRow, data.columnFileName, null);
        }
        if (data.columnFileDescripton) {
            VariableSetService.setValue(table, data.currentRow, data.columnFileDescripton, null);
        }
        if (data.columnFileClassName) {
            VariableSetService.setValue(table, data.currentRow, data.columnFileClassName, null);
        }
    },

    createMenu: function (me, buttonsContainerId, row) {
        me.setContextVariable("currentRow", row);

        let tempDiv = jQuery("<div/>")
        let menuIcon = jQuery("<div/>")
        menuIcon.attr('style', "text-align: center");

        let button = me.buildTemplateIconButton('',
            (event) => me.eventShowMenu(event, row),
            me.getIconClass("cog")
        );
        menuIcon.append(button);
        menuIcon.addClass(me.idComponent);
        tempDiv.append(menuIcon);
        tempDiv.appendTo("#" + buttonsContainerId);
    },

    createIconSpan: function (icon) {
        var span = jQuery("<span/>");
        span.addClass("x4-btn-icon-el");
        span.addClass(this.getIconClass(icon));
        return span;
    },

    createNameSpan: function (name) {
        var span = jQuery("<span/>");
        span.addClass("x4-btn-inner")
        span.addClass("x4-btn-inner-center")
        span.append(name)
        return span;
    },

    buildTamplateButton: function (id) {
        var countBtn = 0;
        if (this.shouldDisplayShowButton()) {
            countBtn++
        }
        if (this.shouldDisplayDetachButton()) {
            countBtn++
        }
        if (this.shouldDisplayAddButton()) {
            countBtn++
        }
        if (this.shouldDisplayDownloadButton()) {
            countBtn++
        }
        var button = jQuery("<button/>");
        button.addClass("x4-btn");
        button.addClass("x4-icon-text-lef");
        button.addClass("x4-btn-icon-text-left");
        button.addClass("x4-btn-default-toolbar-small-icon-text-left");
        button.attr('id', id);
        if (isHistory) {
            if (this.shouldDisplayShowButton()) {
                button.css("width", "96%");
            } else {
                button.css("width", "0%")
            }
        } else {
            button.css("width", (96 / countBtn) + '%');
        }

        button.css("margin-left", "1%");
        button.css("min-height", "22px");
        return button;
    },

    buildTemplateCfg: function (row) {
        var cfg = {};
        cfg["tableID"] = this.tableId;
        cfg["currentRow"] = row;
        cfg["columnMenu"] = this.get("column") ? this.get("column").getId() : null;
        cfg["columnFileId"] = this.get("column-file-id") ? this.get("column-file-id").getId() : null;
        cfg["columnDocId"] = this.get("column-doc-id") ? this.get("column-doc-id").getId() : null;
        cfg["columnFileDate"] = this.get("column-file-date") ? this.get("column-file-date").getId() : null;
        cfg["columnFileName"] = this.get("column-file-name") ? this.get("column-file-name").getId() : null;
        cfg["columnFileDescripton"] = this.get("column-file-descripton") ? this.get("column-file-descripton").getId() : null;
        cfg["columnFileClassName"] = this.get("column-file-class-name") ? this.get("column-file-class-name").getId() : null;
        return cfg;
    },

    buildAddCfg: function (row) {
        var cfg = this.buildTemplateCfg(row);
        cfg["showIndexes"] = this.get("show-indexes");
        cfg["checkRights"] = this.get("check-rights");
        cfg["autoSelectFirst"] = this.get("auto-select-first");
        cfg["docClassNameList"] = this.get("doc-class-list-name") && this.get("doc-class-list-name")[0] ? this.get("doc-class-list-name") : undefined;
        cfg["successMsg"] = this.get("success-msg-add");
        cfg['description'] = this.get("description");
        return cfg;
    },

    buildDetachCfg: function (fileId, row) {
        var cfg = this.buildTemplateCfg(row);
        cfg.removeRow = this.get("remove-row");
        cfg.detachConfirmTitle = this.get("detachConfirmTitle");
        cfg.detachConfirmMsg = this.get("detachConfirmMsg");
        cfg.fileId = fileId;
        cfg.warnDetachAttachments = this.get("warnDetachAtachments");
        return cfg;
    },

    initButtonFun: function () {
        Attachment.showDocument = this.showDocument;
        if (!isHistory) {
            Attachment.addDocument = this.addDocument;
            Attachment.detachDocument = this.detachDocument;
            Attachment.deleteDocument = this.deleteDocument;
            Attachment.downloadDocument = this.downloadDocument;
            Attachment.saveDocument = this.saveDocument;
            Attachment.cancelDocument = this.cancelDocument;
            Attachment.eventShowMenu = this.eventShowMenu;
            Attachment.getDocumentStatus = this.getDocumentStatus;
        }
    },

    errorButtonClickFn: function (rowNo) {
        var data = this.buildTemplateCfg(rowNo);
        var table = VariableSetService.get(this.tableId);
        this.clearRow(data, table);
    },

    showDocument: async function (fileId, newestVersion = false) {
        if (newestVersion) {
            await fetch(PW.getAbsolutePath("/api/documents/"+ parseInt(fileId) +"/versions"))
                .then(data => data.json())
                .then(json => {
                    let newestVersion = json[0];
                    for (let i = 1; i < json.length; i++) {
                        if (json[i].version["version"] > newestVersion.version["version"]) {
                            newestVersion = json[i];
                        }
                    }

                    CUF.DocumentService.showFile(parseInt(newestVersion["id"]));
                });
        } else {
            CUF.DocumentService.showFile(parseInt(fileId));
        }
    },

    addDocument: function (me) {
        var data = jQuery(me).data("cfg");
        var table = VariableSetService.get(data.tableID);
        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: data.showIndexes,
            checkRights: data.checkRights,
            autoSelectFirst: data.autoSelectFirst,
            documentClassNameList: data.docClassNameList,
            fileDescription: data.description,
            callback: function (file) {
                if (data.columnFileDate) {
                    VariableSetService.setValue(table, data.currentRow, data.columnFileDate, new Date());
                }
                if (data.columnFileId) {
                    VariableSetService.setValue(table, data.currentRow, data.columnFileId, file.id);
                }
                if (data.columnDocId) {
                    var filetemp = -1;
                    jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                        type: "GET",
                        async: false,
                        success: function (docId) {
                            filetemp = docId;
                            return true;
                        },
                        error: function (e) {
                            return false;
                        },
                        failure: function (respone) {
                            logger.error(respone);
                        }
                    });
                    VariableSetService.setValue(table, data.currentRow, data.columnDocId, filetemp);
                }
                if (data.columnFileName) {
                    VariableSetService.setValue(table, data.currentRow, data.columnFileName, file.fileName);
                }
                if (data.columnFileDescripton) {
                    VariableSetService.setValue(table, data.currentRow, data.columnFileDescripton, file.description);
                }
                if (data.columnFileClassName) {
                    VariableSetService.setValue(table, data.currentRow, data.columnFileClassName, file.documentClass.name);
                }
                VariableSetService.save(table);
                FormService.save();
                DocumentService.refreshDocuments();
                MessageService.showSuccess(data.successMsg);
            }
        });
    },

    detachDocument: function (me) {
        var data = jQuery(me).data("cfg");
        var table = VariableSetService.get(data.tableID);
        if (data.warnDetachAttachments) {
            MessageService.showConfirm({
                title: data.detachConfirmTitle,
                message: data.detachConfirmMsg,
                yes: function () {
                    CUF.DocumentService.detachDocument(data.fileId, processId, activityId, {
                        success: function (respone) {
                            if (data.removeRow) {
                                table.store.removeAt(data.currentRow);
                            } else {
                                me.clearRow(data, table);
                            }
                            VariableSetService.save(table);
                            FormService.save();
                            DocumentService.refreshDocuments();
                        },
                        failure: function (respone) {
                            logger.error(respone);
                        },
                    });
                }
            });
        } else {
            CUF.DocumentService.detachDocument(data.fileId, processId, activityId, {
                success: function () {
                    if (data.removeRow) {
                        table.store.removeAt(data.currentRow);
                    } else {
                        me.clearRow(data, table);
                    }
                    VariableSetService.save(table);
                    FormService.save();
                    DocumentService.refreshDocuments();
                },
                failure: function (respone) {
                    logger.error(respone);
                },
            });
        }
    },

    deleteDocument: function (me) {
        var data = jQuery(me).data("cfg");
        var table = VariableSetService.get(data.tableID);
        var fileIds = [];
        fileIds.push(data.fileId);
        if (data.warnDetachAttachments) {
            MessageService.showConfirm({
                title: data.detachConfirmTitle,
                message: data.detachConfirmMsg,
                yes: function () {
                    CUF.DocumentService.deleteDocuments(fileIds, {
                        success: function (respone) {
                            for (var rowIndex = 0; rowIndex < VariableSetService.getRowsCount(table); rowIndex++) {
                                if (rowIndex == data.currentRow) {
                                    continue;
                                }
                                if (VariableSetService.getValue(table, rowIndex, me.get("column-file-id").getId()) == data.fileId) {
                                    VariableSetService.setValue(table, rowIndex, me.get("column").getId(), me.errorFileId);
                                }
                            }
                            if (data.removeRow) {
                                table.store.removeAt(data.currentRow);
                            } else {
                                me.clearRow(data, table);
                            }
                            VariableSetService.save(table);
                            FormService.save();
                            DocumentService.refreshDocuments();
                        },
                        failure: function (respone) {
                            logger.error(respone);
                        },
                    });
                }
            });
        } else {
            CUF.DocumentService.deleteDocuments(fileIds, {
                success: function (respone) {
                    for (var rowIndex = 0; rowIndex < VariableSetService.getRowsCount(table); rowIndex++) {
                        if (rowIndex == data.currentRow) {
                            continue;
                        }
                        if (VariableSetService.getValue(table, rowIndex, me.get("column-file-id").getId()) == data.fileId) {
                            VariableSetService.setValue(table, rowIndex, me.get("column").getId(), me.errorFileId);
                        }
                    }
                    if (data.removeRow) {
                        table.store.removeAt(data.currentRow);
                    } else {
                        me.clearRow(data, table);
                    }
                    VariableSetService.save(table);
                    FormService.save();
                    DocumentService.refreshDocuments();
                },
                failure: function (respone) {
                    logger.error(respone);
                },
            });
        }
    },

    getDocumentStatus: function(fileId) {
        return new Promise((resolve, reject) => {
            jQuery.ajax({
                url: 'api/documents/' + fileId + '/status',
                method: "GET",
                success: resolve,
                error: reject
            });
        });
    },

    downloadDocument: async function (me, fileId) {
        const data = jQuery(me).data("cfg");
        const table = VariableSetService.get(data.tableID);

        try {
            const status = await Attachment.getDocumentStatus(fileId);
            
            if (status === "STATE_EDIT") {
                MessageService.showFailure(Attachment.t("attachment.document.state.edit"));
                return;
            }

            await new Promise((resolve, reject) => {
                jQuery.ajax({
                    url: 'api/documents/' + fileId + '/checkOut',
                    method: "PUT",
                    success: resolve,
                    error: reject
                });
            });

            location.href = 'api/documents/download/' + fileId;
            VariableSetService.save(table);

        } catch (error) {
            Logger.error(error);
        }
    },

    saveDocument: async function (me, fileId) {
        const data = jQuery(me).data("cfg");
        const table = VariableSetService.get(data.tableID);

        try {
            const status = await Attachment.getDocumentStatus(fileId);

            if (status !== "STATE_EDIT") {
                MessageService.showFailure(Attachment.t("attachment.document.state.not.edit"));
                return;
            }

            CUF.DocumentService.showSendDocumentsForm(fileId, {
                callback: async function () {
                    try {
                        const file = await new Promise((resolve, reject) => {
                            jQuery.ajax({
                                url: 'plugin/com.suncode.plugin-attachment/api/docs/getFile/' + fileId,
                                method: 'GET',
                                success: resolve,
                                error: reject
                            });
                        });

                        if (data.columnFileDate) {
                            VariableSetService.setValue(table, data.currentRow, data.columnfileDate, new Date());
                        }
                        if (data.columnFileId) {
                            VariableSetService.setValue(table, data.currentRow, data.columnFileId, file.id);
                        }
                        if (data.columnFileDescripton) {
                            VariableSetService.setValue(table, data.currentRow, data.columnFileDescripton, file.description);
                        }
                        if (data.columnFileName) {
                            VariableSetService.setValue(table, data.currentRow, data.columnFileName, file.name);
                        }

                        VariableSetService.save(table);
                        FormService.save();
                        DocumentService.refreshDocuments();

                    } catch (error) {
                        Logger.error(error);
                    }
                }
            });

        } catch (error) {
            Logger.error(error);
        }
    },

    cancelDocument: function (me, fileId) {
        var data = jQuery(me).data("cfg");
        var table = VariableSetService.get(data.tableID);
        jQuery.ajax({
            url: 'api/documents/' + fileId + '/undoCheckOut',
            method: "PUT",
            success: function () {
                VariableSetService.save(table);
            },
            error: function (message) {
                Logger.error(message);
            }
        });
    }
});