/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.attachment.category.Categories;
import com.suncode.plugin.attachment.utils.DataConverter;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.search.IndexFilter;
import com.suncode.pwfl.archive.search.SimpleIndexFilter;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
@Application
public class AttachDocsFromArchive {
    private static final Logger log = LoggerFactory.getLogger(AttachDocsFromArchive.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("attachment.attach-docs-from-archive.dual-app-set")).name("dual-app-set.attach-docs-from-archive.name")).description("dual-app-set.attach-docs-from-archive.desc")).category(new Category[]{Categories.ATTACHMENT})).icon((Icon)SilkIconPack.DATABASE)).parameter().id("docClassName").name("dual-app-set.attach-docs-from-archive.doc-class-name.name").description("dual-app-set.attach-docs-from-archive.doc-class-name.desc").type((Type)Types.STRING).create()).parameter().id("emptyIndexes").name("dual-app-set.attach-docs-from-archive.emptyIndexes.name").description("dual-app-set.attach-docs-from-archive.emptyIndexes.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("indexName").name("dual-app-set.attach-docs-from-archive.index-name.name").description("dual-app-set.attach-docs-from-archive.index-name.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("indexValue").name("dual-app-set.attach-docs-from-archive.index-value.name").description("dual-app-set.attach-docs-from-archive.index-value.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param(value="docClassName") String docClassName, @PairedParam(key="indexName", value="indexValue") Map<String, String> indexMapping, @Param(value="emptyIndexes") Boolean emptyIndexes, WorkflowContext context, Translator translator) throws Exception {
        this.run(docClassName, indexMapping, emptyIndexes, context, translator);
    }

    public void set(@Param(value="docClassName") String docClassName, @PairedParam(key="indexName", value="indexValue") Map<String, String> indexMapping, @Param(value="emptyIndexes") Boolean emptyIndexes, WorkflowContext context, Translator translator) throws Exception {
        this.run(docClassName, indexMapping, emptyIndexes, context, translator);
    }

    private void run(String docClassName, Map<String, String> indexMapping, Boolean emptyIndexes, WorkflowContext context, Translator translator) throws Exception {
        DocumentClass docClass = this.documentClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        if (docClass == null) {
            throw new Exception("Incorect docClassName param: " + docClassName);
        }
        List<IndexFilter> indexFiltr = this.convertIndexes(docClass, indexMapping, emptyIndexes);
        if (indexMapping.isEmpty() || !indexFiltr.isEmpty() || emptyIndexes.booleanValue()) {
            CountedResult findedWfDocuments = this.documentFinder.findByIndexes(docClass.getId(), indexFiltr, null, Integer.valueOf(0), Integer.valueOf(0), new String[0]);
            log.debug("Finded " + findedWfDocuments.getTotal() + " documents");
            for (WfDocument wfDocument : findedWfDocuments.getData()) {
                this.documentService.attachDocumentToProcess(wfDocument, "admin", context.getProcessId(), context.getActivityId());
                this.documentClassActionService.executeProcessActions(wfDocument, DocumentEventTypes.ADD_DOCUMENT_TO_PROCESS, context.getProcessId(), context.getActivityId());
            }
        }
    }

    private List<IndexFilter> convertIndexes(DocumentClass docClass, Map<String, String> indexMapping, Boolean emptyIndexes) {
        ArrayList<IndexFilter> result = new ArrayList<IndexFilter>();
        Set indexes = docClass.getIndexes();
        for (DocumentClassIndex documentClassIndex : indexes) {
            String stringValue;
            if (!indexMapping.containsKey(documentClassIndex.getName()) || StringUtils.isBlank((CharSequence)(stringValue = indexMapping.get(documentClassIndex.getName()))) && !emptyIndexes.booleanValue()) continue;
            SimpleIndexFilter indexFiltr = DataConverter.buildIndexFiltr(stringValue, documentClassIndex);
            result.add((IndexFilter)indexFiltr);
        }
        return result;
    }
}

