/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.applications;

import com.suncode.plugin.attachment.category.Categories;
import com.suncode.plugin.attachment.enums.DocumentParameters;
import com.suncode.plugin.attachment.utils.DataConverter;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class ReadDocumentInfos {
    private static final Logger log = LoggerFactory.getLogger(ReadDocumentInfos.class);
    @Autowired
    private DocumentFinder docFinder;
    @Autowired
    private DocumentClassService docClassService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("attachment.read-doc-info.dual")).name("dual.read-doc-info.name")).description("dual.read-doc-info.desc")).category(new Category[]{Categories.ATTACHMENT})).icon((Icon)SilkIconPack.DATABASE)).parameter().id("docClassName").name("dual.attachment.param.docClassName.name").type((Type)Types.STRING).create()).parameter().id("docParam").name("dual.attachment.param.docParam.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("docPramVariable").name("dual.attachment.param.docPramVariable.name").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("indexName").name("dual.attachment.param.indexName.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("indexNameValue").name("dual.attachment.param.indexNameValue.name").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("constParam").name("dual.attachment.param.constParam.name").optional().type((Type)Types.STRING_ARRAY).create()).parameter().id("constParamVariable").name("dual.attachment.param.constParamVariable.name").optional().type((Type)Types.VARIABLE_ARRAY).create();
    }

    public void execute(@Param String docClassName, @PairedParam(key="docParam", value="docPramVariable") Map<String, Variable> docParamMap, @PairedParam(key="indexName", value="indexNameValue") Map<String, Variable> indexMap, @PairedParam(key="constParam", value="constParamVariable") Map<String, Variable> constParamMap, ActivityContextMap context, Translator translator) throws Exception {
        this.run(docClassName, docParamMap, indexMap, constParamMap, context, translator);
    }

    public void set(@Param String docClassName, @PairedParam(key="docParam", value="docPramVariable") Map<String, Variable> docParamMap, @PairedParam(key="indexName", value="indexNameValue") Map<String, Variable> indexMap, @PairedParam(key="constParam", value="constParamVariable") Map<String, Variable> constParamMap, ActivityContextMap context, Translator translator) throws Exception {
        this.run(docClassName, docParamMap, indexMap, constParamMap, context, translator);
    }

    private void run(@Param String docClassName, @PairedParam(key="docParam", value="docPramVariable") Map<String, Variable> docParamMap, @PairedParam(key="indexName", value="indexNameValue") Map<String, Variable> indexMap, @PairedParam(key="constParam", value="constParamVariable") Map<String, Variable> constParamMap, ActivityContextMap context, Translator translator) throws Exception {
        List<WfDocument> docs2Read = this.getFilteredWfDocuments(context, docClassName);
        Map<String, Variable> varMap = this.collectVariables(docParamMap, indexMap, constParamMap);
        HashMap<String, List<String>> mapping = new HashMap<String, List<String>>();
        for (WfDocument wfDocument : docs2Read) {
            this.readDocParameters(docClassName, docParamMap, mapping, wfDocument);
            this.readDocIndexes(indexMap, mapping, wfDocument);
            this.readConstValues(constParamMap, mapping);
        }
        this.updateProcessContext(context, varMap, mapping);
    }

    private List<WfDocument> getFilteredWfDocuments(ActivityContextMap context, String docClassName) {
        List docsFromActivity = this.docFinder.getDocumentsFromActivity(context.getProcessId(), context.getActivityId(), new String[0]);
        DocumentClass docClass = this.docClassService.getDocumentClass(docClassName, new String[0]);
        return docsFromActivity.stream().filter(wfDocument -> wfDocument.getDocumentClassId() == docClass.getId()).collect(Collectors.toList());
    }

    private void updateProcessContext(ActivityContextMap context, Map<String, Variable> varMap, Map<String, List<String>> mapping) {
        for (String id : varMap.keySet()) {
            if (!mapping.containsKey(id)) continue;
            Variable variable = context.getVariable(id);
            String valueAsBasicType = (String)variable.getValueAsBasicType();
            if (valueAsBasicType instanceof String) {
                String newValue = String.join((CharSequence)";", (Iterable<? extends CharSequence>)mapping.get(id));
                if (!StringUtils.isBlank((CharSequence)valueAsBasicType)) {
                    valueAsBasicType = valueAsBasicType + ";";
                }
                valueAsBasicType = valueAsBasicType + newValue;
            }
            variable.setValue(DataConverter.stringToObject(valueAsBasicType, variable.getPmidxType()));
        }
    }

    private void readConstValues(Map<String, Variable> constParamMap, Map<String, List<String>> mapping) {
        for (String constValue : constParamMap.keySet()) {
            if (constParamMap.get(constValue) == null) continue;
            String mappingId = constParamMap.get(constValue).getId();
            if (!mapping.containsKey(mappingId)) {
                mapping.put(mappingId, new ArrayList());
            }
            mapping.get(mappingId).add(constValue);
        }
    }

    private void readDocIndexes(Map<String, Variable> indexMap, Map<String, List<String>> mapping, WfDocument wfDocument) {
        for (String indexName : indexMap.keySet()) {
            IndexInfo indexInfo;
            if (indexMap.get(indexName) == null) continue;
            String mappingId = indexMap.get(indexName).getId();
            if (!mapping.containsKey(mappingId)) {
                mapping.put(mappingId, new ArrayList());
            }
            if ((indexInfo = wfDocument.getIndexByName(indexName)) == null) {
                mapping.get(mappingId).add(" ");
                continue;
            }
            Object value = indexInfo.getValue();
            if (value != null) {
                log.debug(indexInfo.getName() + " : " + value.toString());
                mapping.get(mappingId).add(value.toString());
                continue;
            }
            mapping.get(mappingId).add(" ");
        }
    }

    private void readDocParameters(String docClassName, Map<String, Variable> docParamMap, Map<String, List<String>> mapping, WfDocument wfDocument) {
        for (String paramKey : docParamMap.keySet()) {
            if (docParamMap.get(paramKey) == null) continue;
            String mappingId = docParamMap.get(paramKey).getId();
            if (!mapping.containsKey(mappingId)) {
                mapping.put(mappingId, new ArrayList());
            }
            mapping.get(mappingId).add(this.readParam(wfDocument, paramKey, docClassName, docParamMap));
        }
    }

    private String readParam(WfDocument wfDocument, String paramKey, String docClassName, Map<String, Variable> docParamMap) {
        switch (DocumentParameters.getEnum(paramKey)) {
            case ID: {
                return wfDocument.getId().toString();
            }
            case COMMENT: {
                String comment = wfDocument.getVersion().getComment();
                return comment == null ? "" : comment.replaceAll(";", ",");
            }
            case DESCRIPTION: {
                String desc = wfDocument.getFile().getDescription();
                return desc == null ? "" : desc.replaceAll(";", ",");
            }
            case DOC_CLASS_ID: {
                return wfDocument.getDocumentClassId().toString();
            }
            case DOC_CLASS_NAME: {
                return docClassName;
            }
            case EXPIRATION_DATE: {
                return this.convertDate(wfDocument.getExpirationDate(), docParamMap.get(paramKey).getType());
            }
            case FILE_DATE: {
                return this.convertDate(wfDocument.getFile().getFileDate(), docParamMap.get(paramKey).getType());
            }
            case FILE_ID: {
                return new Long(wfDocument.getFile().getId()).toString();
            }
            case FIlE_NAME: {
                return wfDocument.getFile().getFileName();
            }
            case FILE_PATH: {
                return wfDocument.getFile().getFullPath();
            }
            case FILE_SIZE: {
                return new Long(wfDocument.getFile().getSize()).toString();
            }
            case UPLOADER: {
                return wfDocument.getFile().getUploader();
            }
            case VERSION: {
                return new Long(wfDocument.getVersion().getVersion()).toString();
            }
        }
        return "";
    }

    private String convertDate(Date tempDate, Type<?> type) {
        String typeName = type.name();
        if (tempDate != null) {
            if (typeName.equalsIgnoreCase("date[]")) {
                SimpleDateFormat formatterDate = new SimpleDateFormat("yyyy-MM-dd");
                return formatterDate.format(tempDate);
            }
            SimpleDateFormat formatterDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return formatterDateTime.format(tempDate);
        }
        return null;
    }

    private Map<String, Variable> collectVariables(Map<String, Variable> docParamMap, Map<String, Variable> indexMap, Map<String, Variable> constParamMap) {
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        this.readVariables(docParamMap, varMap);
        this.readVariables(indexMap, varMap);
        this.readVariables(constParamMap, varMap);
        return varMap;
    }

    private void readVariables(Map<String, Variable> inputMap, Map<String, Variable> varMap) {
        for (Variable var : inputMap.values()) {
            if (var == null || varMap.containsKey(var.getId())) continue;
            varMap.put(var.getId(), var);
        }
    }
}

