PWE.integrationComponent.registerApplication('attachment.read-doc-info.dual', {
	apiVersion: 2,
	buildForm: function (form) {
		Attachment.addComboboxClassList("docClassName", {
			change: function (value) {
				form.removeField("indexName");
				Attachment.addComboboxClassIndexList("indexName", value, null, indexTable, 0);
				Attachment.resetColumnValue("indexName", form);
			}
		}, form, null, false);

		form.show("docClassName");
		var indexTable = form.addTable({
			id: "indexTable",
			name: Attachment.t("dpwe.indexTable.name"),
		});
		Attachment.addComboboxClassIndexList("indexName", form.getValue("docClassName"), null, indexTable, 0);
		indexTable.addField({
			id: "indexNameValue"
		});

		var tableParam = form.addTable({
			id: 'tableParam',
			name: Attachment.t("dpwe.docParamTable.name"),
		});
		Attachment.addComboboxDocParamList("docParam", null, tableParam, null);
		tableParam.addField('docPramVariable');

		var tableConst = form.addTable({
			id: 'tableConst',
			name: Attachment.t("dpwe.constTable.name"),
		});
		tableConst.addField('constParam');
		tableConst.addField('constParamVariable');
	},
	validateForm: function (api) {
		var validateFlag = true;

		var validArrayFlag = true;
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'indexNameValue');
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'docPramVariable');
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'constParamVariable');

		var validEmptyFlag = true;
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'indexName');
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'docParam');
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'constParam');

		validateFlag &= validArrayFlag;
		validateFlag &= validEmptyFlag;
		if (!validateFlag) {
			var errorMsg = Attachment.t("dpwe.validateError");
			if (!validArrayFlag) {
				errorMsg += "<br>";
				errorMsg += Attachment.t("dpwe.validateArrayParam");
			}
			if (!validEmptyFlag) {
				errorMsg += "<br>";
				errorMsg += Attachment.t("dpwe.validateEmptyError");
			}
			api.showErrorMessage(errorMsg);
			return false;
		}
		return true;
	}
});

PWE.integrationComponent.registerVariablesSetter('attachment.read-doc-info.dual', {
	apiVersion: 2,
	buildForm: function (form) {
		Attachment.addComboboxClassList("docClassName", {
			change: function (value) {
				form.removeField("indexName");
				Attachment.addComboboxClassIndexList("indexName", value, null, indexTable, 0);
				Attachment.resetColumnValue("indexName", form);
			}
		}, form, null, false);

		form.show("docClassName");
		var indexTable = form.addTable({
			id: "indexTable",
			name: Attachment.t("dpwe.indexTable.name"),
		});
		Attachment.addComboboxClassIndexList("indexName", form.getValue("docClassName"), null, indexTable, 0);
		indexTable.addField({
			id: "indexNameValue"
		});

		var tableParam = form.addTable({
			id: 'tableParam',
			name: Attachment.t("dpwe.docParamTable.name"),
		});
		Attachment.addComboboxDocParamList("docParam", null, tableParam, null);
		tableParam.addField('docPramVariable');

		var tableConst = form.addTable({
			id: 'tableConst',
			name: Attachment.t("dpwe.constTable.name"),
		});
		tableConst.addField('constParam');
		tableConst.addField('constParamVariable');
	},
	validateForm: function (api) {
		var validateFlag = true;

		var validArrayFlag = true;
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'indexNameValue');
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'docPramVariable');
		validArrayFlag &= Attachment.validateVariableArrayValue(api, 'constParamVariable');

		var validEmptyFlag = true;
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'indexName');
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'docParam');
		validEmptyFlag &= Attachment.validateEmptyArrayValue(api, 'constParam');

		validateFlag &= validArrayFlag;
		validateFlag &= validEmptyFlag;
		if (!validateFlag) {
			var errorMsg = Attachment.t("dpwe.validateError");
			if (!validArrayFlag) {
				errorMsg += "<br>";
				errorMsg += Attachment.t("dpwe.validateArrayParam");
			}
			if (!validEmptyFlag) {
				errorMsg += "<br>";
				errorMsg += Attachment.t("dpwe.validateEmptyError");
			}
			api.showErrorMessage(errorMsg);
			return false;
		}
		return true;
	}
});