PW.FormActions.create('attachment.update-description-file', {
    variableSetInit: function (table) {
        this.tableId = table.getId();
        this.tableSet = VariableSetService.get(this.tableId);
        this.columnIDs = [];
        var me = this;
        jQuery(this.get('updateColumn')).each(function (index, item) { me.columnIDs.push(item.getId()); })
    },
    enable: function () {

    },
    disable: function () {
    },
    defaultActions: {
        button: function (button) { },
        variable: function (variable, newValue, oldValue) { },
        variableSet: function (variableSet, added, updated, removed) {
            if (updated.length > 0) {
                for (updateIndex = 0; updateIndex < updated.length; updateIndex++) {
                    var currentRow = updated[updateIndex].index;
                    this.setContextVariable("currentRow", currentRow);
                    var fileId = VariableSetService.getValue(this.tableSet, currentRow, this.get('columnFileId').getId());
                    if (fileId) {
                        for (indexColumn = 0; indexColumn < updated[updateIndex].changes.length; indexColumn++) {
                            if (this.columnIDs.includes(updated[updateIndex].changes[indexColumn])) {
                                FormService.mask();
                                descriptionFile = this.get('descriptionFile');
                                jQuery.ajax({
                                    url: 'plugin/com.suncode.plugin-attachment/api/doc/updateDescription',
                                    type: "POST",
                                    async: false,
                                    data: {
                                        processId: processId,
                                        fileId: fileId,
                                        descriptionFile: descriptionFile
                                    },
                                    success: function (data) {
                                        if (!data.success) {
                                            Logger.error(Attachment.t(data.message));
                                            Logger.error("FileId\t" + fileId);
                                            MessageService.showFailure(Attachment.t(data.message));
                                        } else {
                                            DocumentService.refreshDocuments();
                                        }
                                        FormService.unmask();
                                    },
                                    error: function (error) {
                                        FormService.unmask();
                                        MessageService.showFailure(Attachment.t("attachment.msg.server.error"));
                                    }
                                });
                                return;
                            }
                        }
                    }
                }

            }

        }
    }
});
