PW.FormActions.create('attachment.document-info.action', {
	variableSetInit : function(table) {
		this.tableId = table.getId();

	},

	enable : function() {
		var me = this;
		this.table = VariableSetService.get(this.tableId);
		this.idDocInfo = 'docinfo-' + Math.floor(Math.random() * 1000);
		var rowsCount = VariableSetService.getRowsCount(this.table);
		VariableSetService.addRenderer(this.table, function(value, data,
				column, metaData) {
			metaData.encode = false;
			var div = jQuery("<div/>");
			div.append(me.createDocinfo(me, metaData.row));
			
			Ext4.defer(function () {
				var docInfo = jQuery('#' + me.idDocInfo + "-row_" + metaData.row);
				if (docInfo.get(0) == undefined || (
					jQuery._data(docInfo.parent().parent().get(0), 'events') != undefined &&
					jQuery._data(docInfo.parent().parent().get(0), 'events').click != undefined)) {
					return;
				}
//				docInfo.parent().on("click", me.clickEvent);
				docInfo.parent().parent().on("click", me.clickEvent);
				var objId=new Object();
				objId.iconId='#' + me.idDocInfo + "-row_" + metaData.row;
				docInfo.parent().data(objId);
				docInfo.parent().parent().data(objId);
				docInfo.data(me);
			}, 1, me);
			
			return div.html();
		}, [ this.get("columnRender").getId() ]);

	},
	disable : function() {
		VariableSetService.removeRenderers(this.table, [ this.get(
				"columnRender").getId() ]);
	},
	createDocinfo : function(me, row) {
		idDocInfo = me.idDocInfo;
		var tempDiv = jQuery('<div/>');
		var img = jQuery('<img/>', {
			id: idDocInfo + "-row_" + row
		});
		img.attr("src",'style/img/fam/information.png');
		tempDiv.append(img);
		return tempDiv.html();
	},
	clickEvent: function (event) {
		FormService.mask();
		event.stopPropagation();
		event.preventDefault();
		target=jQuery(event.target);
		var me=target.data();
		var rowIndex=-1;
		if(me.iconId){
			 rowIndex = Number(me.iconId.split("_")[1]);
			 me = jQuery(me.iconId).data();
		}else{
			id=target.attr('id')
			rowIndex = Number(id.split("_")[1]);
		}
	var	fileId = VariableSetService.getValue(me.table, rowIndex, me.get("columnFileId").getId());
		jQuery.ajax({
			url: 'plugin/com.suncode.plugin-attachment/api/docs/getDocumentClassId',
			type: 'POST',
			data: {
				processid: processId,
				fileid: fileId
			},
			success: function (data) {
				if (data.success) {
					FormService.unmask();
					PW.ui.ModalWindow.show(Attachment.t('web.multi.window.info.titile'),
					        Suncode.getAbsolutePath("ShowDocumentInformation.do?fileId="+btoa(fileId)+"&docClassId="+data.data),{
					            bodyCls: "form-document-info-window",
					            iconCls: "silk-information",
					            shadow: false,
					            width: "auto",
					            xtype: "window"}
					            );
				} else {
					FormService.unmask();
					Logger.error(Attachment.t(data.message));
					MessageService.showFailure(Attachment.t(data.message));
				}
			},
			error: function (data) {
				MessageService.showFailure(Attachment.t("attachment.msg.server.error"));
				Logger.error(data.message);
			},
			complete: function () {
				FormService.unmask();
			}
		});
	}
});