PW.FormActions.create('read-document-infos-action', {
	init: function() {
		this.fileIdColumnVar = this.get("fileIdColumnVar");
		this.docIndexNameVar = this.get("docIndexNameVar");
		this.docParamVar = this.get("docParamVar");
		this.constParamVar = this.get("constParamVar");
	},

	defaultActions: {
		variableSet: function(variableSet, added, updated, removed) {
			this.currentVariableSet = VariableSetService.get(variableSet.getId());
			this.addFn(added);
			this.updateFn(updated);
		}
	},

	addFn: function(added) {
		if (added) {
			const columnId = this.fileIdColumnVar.getId();
			for (let j = 0; j < added.length; j++) {
				const record = added[j].record.record;
				const indexRow = VariableSetService.getRowIndex(this.currentVariableSet, record);
				this.setContextVariable("currentRow", indexRow);
				this.setConstantValue(record);
				this.getFileInfoByFileId(record.data[columnId], record);
			}
		}
	},

	updateFn: function(updated) {
		if (updated) {
			const columnId = this.fileIdColumnVar.getId();
			for (let j = 0; j < updated.length; j++) {
				if (updated[j].changes.indexOf(columnId) > -1) {
					const record = updated[j].record.record;
					const indexRow = VariableSetService.getRowIndex(this.currentVariableSet, record);
					this.setContextVariable("currentRow", indexRow);
					this.setConstantValue(record);
					this.getFileInfoByFileId(record.data[columnId], record);
				}
			}
		}
	},

	setDocIndexNameVar: function(indexesList, record) {
		const indexesArr = [];
		if (indexesList.length == 0) {
			return;
		}
		const rowIndex = VariableSetService.getRowIndex(this.currentVariableSet, record);
		for (let i = 0; i < indexesList.length; i++) {
			const index = indexesList[i];
			indexesArr[index.name] = index.value;
		}
		const docIndexesArray = this.get("docIndexesArray");
		for (let i = 0; i < this.docIndexNameVar.length; i++) {
			if (indexesArr.hasOwnProperty(docIndexesArray[i])) {
				this.docIndexNameVar[i].setItemValue(indexesArr[docIndexesArray[i]], rowIndex);
			}
		}
	},

	setConstantValue: function(record) {
		const rowIndex = VariableSetService.getRowIndex(this.currentVariableSet, record);
		const constParamArr = this.get("constParam");
		for (let i = 0; i < this.constParamVar.length; i++) {
			this.constParamVar[i].setItemValue(constParamArr[i], rowIndex);
		}
		FormService.save();
	},

	getFileInfoByFileId: function(fileId, record) {
		const me = this;
		FormService.mask();
		jQuery.ajax({
			type: "GET",
			url: "plugin/com.suncode.plugin-attachment/api/docs/fileInfo/",
			data: {
				fileId: fileId,
				processId: processId,
				activityId: activityId

			},
			error: function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			},
			async: true
		})
			.done(function(restResult) {
				if (restResult.success) {
					const rowIndex = VariableSetService.getRowIndex(me.currentVariableSet, record);
					const actionParamName = me.get("docParam");
					const docParamVar = me.get("docParamVar");

					for (let i = 0; i < actionParamName.length; i++) {
						docParamVar[i].setItemValue(me.getFileParamValueByKey(actionParamName[i], restResult.data), rowIndex);
					}
					me.setDocIndexNameVar(restResult.data.indexes, record);
					FormService.save();
				}
				else {
					MessageService.showFailure( Attachment.t( restResult.message ) );
					Logger.error( "Document with id: " + fileId + " does not exist" );
				}
			})
			.fail(function() {
				Logger.error("Request failed.");
			})
			.always(function() {
				FormService.unmask();
			});
		return;
	},

	getFileParamValueByKey: function(key, fileInfo) {
		switch (key) {
			case "document.parameters.id": return fileInfo.documentId;
			case "document.parameters.file.id": return fileInfo.id;
			case "document.parameters.docclass.id": return fileInfo.documentClassId;
			case "document.parameters.docclass.name": return fileInfo.documentClassName;
			case "document.parameters.expiration.date": return this.toSimpleDateFormat(fileInfo.expirationDate);
			case "document.parameters.description": return fileInfo.description;
			case "document.parameters.file.name": return fileInfo.name;
			case "document.parameters.file.date": return this.toSimpleDateFormat(fileInfo.fileDate);
			case "document.parameters.file.path": return fileInfo.filePath;
			case "document.parameters.file.size": return fileInfo.fileSize;
			case "document.parameters.uploader": return fileInfo.uploader;
			case "document.parameters.version": return fileInfo.fileVersion;
			case "document.parameters.comment": return fileInfo.comment;
			default: return "";
		}
	},

	toSimpleDateFormat: function(timestamp) {
		if (!timestamp) {
			return "";
		}
		const date = new Date(timestamp);
		return date.toISOString().substring(0, 10);
	}
});