PW.FormActions.create('attachment.actions.addAttachmentAction', {

    dtButtonInit: function (button) {
        this.table = VariableSetService.get(button.getVariableSet().getId());
        this.settings = {};
        this.settings["columnFileId"] = this.get("columnFileId");
        this.settings["columnDocId"] = this.get("columnDocId");
        this.settings["columnFileDate"] = this.get("columnFileDate");
        this.settings["columnFileName"] = this.get("columnFileName");
        this.settings["columnFileDescription"] = this.get("columnFileDescription");
        this.settings["columnFileClassName"] = this.get("columnFileDocumentClassName");
        this.settings["showIndexes"] = this.get("showIndexes");
        this.settings["checkRights"] = this.get("checkRights");
        this.settings["autoSelectFirst"] = this.get("autoSelectFirst");
        this.settings["refreshAfterAdd"] = this.get("refreshAfterAdd");
        this.settings["addNewRow"] = this.get("addNewRow");
        this.classesList = this.get("documentClassName");
    },

    defaultActions: {
        dtButton: function(){
            this.addAttachment(this.table, this.settings, this.classesList);
        }
    },

    addAttachment: function (table, settings, fileClasses) {
        let selectedRow = VariableSetService.getSelected(table);
        CUF.DocumentService.showAddDocumentsFromDiscForm({
            showIndexes: settings["showIndexes"],
            checkRights: settings["checkRights"],
            autoSelectFirst: settings["autoSelectFirst"],
            documentClassNameList: fileClasses,
            refreshAfterAdd: settings["refreshAfterAdd"],
            callback: function (file) {
                if (settings["addNewRow"] === true || selectedRow == null) {
                    let row = {};
                    if (settings["columnFileDate"]) {
                        row[settings["columnFileDate"].getId()] = new Date();
                    }
                    if (settings["columnFileId"]) {
                        row[settings["columnFileId"].getId()] = file.id;
                    }
                    if (settings["columnDocId"]) {
                        let docIdTemp = -1;
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                docIdTemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                            }
                        });
                        row[settings["columnDocId"].getId()] = docIdTemp;
                    }
                    if (settings["columnFileName"]) {
                        row[settings["columnFileName"].getId()] = file.fileName;
                    }
                    if (settings["columnFileDescription"]) {
                        row[settings["columnFileDescription"].getId()] = file.description;
                    }
                    if (settings["columnFileClassName"]) {
                        row[settings["columnFileClassName"].getId()] = file.documentClass.name;
                    }
                    VariableSetService.addRow(table, false, row);
                } else {
                    let indexRow = VariableSetService.getRowIndex(table, selectedRow);
                    if (settings["columnFileDate"]) {
                        VariableSetService.setValue(table, indexRow, settings["columnFileDate"].getId(), new Date());
                    }
                    if (settings["columnFileId"]) {
                        VariableSetService.setValue(table, indexRow, settings["columnFileId"].getId(), file.id);
                    }
                    if (settings["columnDocId"]) {
                        let filetemp = -1;
                        jQuery.ajax({
                            url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                            type: "GET",
                            async: false,
                            success: function (docId) {
                                filetemp = docId;
                                return true;
                            },
                            error: function () {
                                console.log("error ajax plugin/com.suncode.plugin-attachment/api/docid/ ");
                                return false;
                            }
                        });
                        VariableSetService.setValue(table, indexRow, settings["columnDocId"].getId(), filetemp);
                    }
                    if (settings["columnFileName"]) {
                        VariableSetService.setValue(table, indexRow, settings["columnFileName"].getId(), file.fileName);
                    }
                    if (settings["columnFileDescription"]) {
                        VariableSetService.setValue(table, indexRow, settings["columnFileDescription"].getId(), file.description);
                    }
                    if (settings["columnFileClassName"]) {
                        VariableSetService.setValue(table, indexRow, settings["columnFileClassName"].getId(), file.documentClass.name);
                    }
                    VariableSetService.save(table);
                }
                FormService.save();
            }
        });
    }
});