/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.duals;

import com.suncode.pdfutils.support.InsertedFileProperties;
import com.suncode.pdfutils.support.enums.ImageDestinationPage;
import com.suncode.pdfutils.support.enums.ImagePositionOnPage;
import com.suncode.plugin.attachment.category.Categories;
import com.suncode.plugin.attachment.configuration.enums.GraphicFileSource;
import com.suncode.plugin.attachment.duals.parameters.InsertGraphicFileToPdfParameters;
import com.suncode.plugin.attachment.services.AttachDocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/insert-graphic-file-to-pdf-form.js")
public class InsertGraphicFileToPdf {
    private static final Logger log = LoggerFactory.getLogger(InsertGraphicFileToPdf.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private AttachDocumentService attachDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("attachment.duals.InsertGraphicFileToPdf")).name("attachment.duals.InsertGraphicFileToPdf.name")).description("attachment.duals.InsertGraphicFileToPdf.desc")).category(new Category[]{Categories.ATTACHMENT})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileId").name("attachment.duals.InsertGraphicFileToPdf.param.fileId.name").description("attachment.duals.InsertGraphicFileToPdf.param.fileId.desc").type((Type)Types.INTEGER).create()).parameter().id("graphicFileSource").name("attachment.duals.InsertGraphicFileToPdf.param.graphicFileSource.name").description("attachment.duals.InsertGraphicFileToPdf.param.graphicFileSource.desc").type((Type)Types.STRING).create()).parameter().id("graphicFilePath").name("attachment.duals.InsertGraphicFileToPdf.param.graphicFilePath.name").description("attachment.duals.InsertGraphicFileToPdf.param.graphicFilePath.desc").type((Type)Types.STRING).optional().create()).parameter().id("graphicFileId").name("attachment.duals.InsertGraphicFileToPdf.param.graphicFileId.name").description("attachment.duals.InsertGraphicFileToPdf.param.graphicFileId.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("imageDestinationPage").name("attachment.duals.InsertGraphicFileToPdf.param.imageDestinationPage.name").description("attachment.duals.InsertGraphicFileToPdf.param.imageDestinationPage.desc").type((Type)Types.STRING).create()).parameter().id("imagePositionOnPage").name("attachment.duals.InsertGraphicFileToPdf.param.imagePositionOnPage.name").description("attachment.duals.InsertGraphicFileToPdf.param.imagePositionOnPage.desc").type((Type)Types.STRING).create()).parameter().id("graphicsWidth").name("attachment.duals.InsertGraphicFileToPdf.param.graphicsWidth.name").description("attachment.duals.InsertGraphicFileToPdf.param.graphicsWidth.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("documentScaling").name("attachment.duals.InsertGraphicFileToPdf.param.documentScaling.name").description("attachment.duals.InsertGraphicFileToPdf.param.documentScaling.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("saveAsNewVersion").name("attachment.duals.InsertGraphicFileToPdf.param.saveAsNewVersion.name").description("attachment.duals.InsertGraphicFileToPdf.param.saveAsNewVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("targetDocumentClassName").name("attachment.duals.InsertGraphicFileToPdf.param.targetDocumentClassName.name").description("attachment.duals.InsertGraphicFileToPdf.param.targetDocumentClassName.desc").type((Type)Types.STRING).optional().create()).parameter().id("addDocumentToProcess").name("attachment.duals.InsertGraphicFileToPdf.param.addDocumentToProcess.name").description("attachment.duals.InsertGraphicFileToPdf.param.addDocumentToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("executeArchiveActions").name("attachment.duals.InsertGraphicFileToPdf.param.executeArchiveActions.name").description("attachment.duals.InsertGraphicFileToPdf.param.executeArchiveActions.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(Parameters parameters, ApplicationContext context) throws AcceptanceException {
        this.run(parameters, (WorkflowContext)context);
    }

    public void set(Parameters parameters, AcceptanceContext context) throws AcceptanceException {
        this.run(parameters, (WorkflowContext)context);
    }

    private void run(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        InsertGraphicFileToPdfParameters componentParameters = new InsertGraphicFileToPdfParameters(parameters);
        try {
            WfFile pdfFile = this.fileService.getFile(componentParameters.getFileId(), new String[0]);
            Assert.notNull((Object)pdfFile, (String)"File does not exist in system archive");
            Assert.isTrue((boolean)this.attachDocumentService.isDocumentPDFFormat(pdfFile.getFileName()), (String)"Document is not in PDF format");
            InputStream imageFileStream = this.getImageFileInputStream(componentParameters.getGraphicFileSource(), componentParameters.getGraphicFilePath(), componentParameters.getGraphicFileId());
            InsertedFileProperties insertedFileProperties = this.buildInsertedFileProperties(imageFileStream, componentParameters.getImageDestinationPage(), componentParameters.getImagePositionOnPage(), componentParameters.getGraphicsWidth(), componentParameters.getDocumentScaling());
            byte[] modifiedPdfData = this.addGraphicFileToPdfFile(componentParameters.getFileId(), insertedFileProperties);
            this.attachDocumentService.addFileToArchive(pdfFile, componentParameters.getTargetDocumentClassName(), modifiedPdfData, componentParameters.getSaveAsNewVersion(), componentParameters.getAddDocumentToProcess(), componentParameters.getExecuteArchiveActions(), context.getProcessId(), context.getActivityId());
            log.debug("Graphic file has been inserted into the PDF. The modified PDF document: {} has been successfully saved to the archive", (Object)pdfFile.getFileName());
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private InputStream getImageFileInputStream(String graphicFileSource, String graphicFilePath, Long graphicFileId) throws IOException {
        switch (GraphicFileSource.valueOf(graphicFileSource)) {
            case ABSOLUTE_PATH: {
                return Files.newInputStream(Paths.get(graphicFilePath, new String[0]), new OpenOption[0]);
            }
            case DOCUMENT_ARCHIVE: {
                return this.fileService.getFileInputStream(graphicFileId);
            }
        }
        throw new IllegalArgumentException("Graphic file source is incorrect: " + graphicFileSource);
    }

    private InsertedFileProperties buildInsertedFileProperties(InputStream inputStream, String imageDestinationPage, String imagePositionOnPage, Integer graphicsWidth, Boolean documentScaling) {
        return InsertedFileProperties.builder().fileInputStream(inputStream).imageDestinationPage(ImageDestinationPage.valueOf((String)imageDestinationPage)).imagePositionOnPage(ImagePositionOnPage.valueOf((String)imagePositionOnPage)).imageWidthPercentage(graphicsWidth).documentScaling(documentScaling).build();
    }

    /*
     * Exception decompiling
     */
    private byte[] addGraphicFileToPdfFile(long fileId, InsertedFileProperties insertedFileProperties) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

