PWE.integrationComponent.registerFormAction('buttons-for-attachments-in-column', {
    apiVersion : 2,
    buildForm: function(form, options) {
    	addGeneralSettings(form);
    	addButtonSetSettings(form);
    }
});

function addGeneralSettings(form) {
	var settings = form.addFieldSet({
		id: "general-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.general-settings")
	});
	settings.addCombobox({
		id: "display-method",
		values: [
			{ id: "CONTEXT-MENU", display: Attachment.t("action.buttons-for-attachments-in-column.context-menu") },
			{ id: "BUTTONS", display: Attachment.t("action.buttons-for-attachments-in-column.buttons") }
		]
	});
	settings.addField("column");
	settings.addField("column-file-id");
	addAdditionalGeneralSettings(settings);
};

function addAdditionalGeneralSettings(settings) {
	var additionalSettings = settings.addFieldSet({
		id: "general-additional-settings-fs",
		collapsible: true,
		collapsed: true,
		title: Attachment.t("action.buttons-for-attachments-in-column.more-document-info")
	});
	additionalSettings.addField("column-doc-id");
	additionalSettings.addField("column-file-name");
	additionalSettings.addField("column-file-date");
	additionalSettings.addField("column-file-descripton");
	additionalSettings.addField("column-file-class-name");
};

function addButtonSetSettings(form) {
	var settings = form.addFieldSet({
		id: "buttons-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.action-set-configuration")
	});	
	addShowActionSettings(settings);
	addAttachActionSettings(settings);
	addDetachActionSettings(settings);
	addDownloadActionSettings(settings);
};

function addShowActionSettings(settings) {
	var showActionSettings = settings.addFieldSet({
		id: "show-action-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.show-action-settings")
	});
	
	showActionSettings.addField({
		id: "hide-show-btn",
		listeners: {
			change: function(value) {
				if (value) {
					showActionSettings.hide("show-button-name");
					showActionSettings.hide("show-icon-name");			
					showActionSettings.hide("newest-file-version");
				} else {
					showActionSettings.show("show-button-name");
					showActionSettings.show("show-icon-name");
					showActionSettings.show("newest-file-version");
				}
			}
		}
	});
	
	showActionSettings.addField("show-button-name");
	Attachment.addComboboxIconList("show-icon-name", null, showActionSettings, null);
	showActionSettings.addField("newest-file-version");
	
	if (showActionSettings.getValue("hide-show-btn")) {
		showActionSettings.hide("show-button-name");
		showActionSettings.hide("show-icon-name");
		showActionSettings.hide("newest-file-version");
	} else {
		showActionSettings.show("show-button-name");
		showActionSettings.show("show-icon-name");
		showActionSettings.show("newest-file-version");
	}
};

function addAttachActionSettings(settings) {
	var attachActionSettings = settings.addFieldSet({
		id: "attach-action-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.attach-action-settings")
	});
	
	attachActionSettings.addField({
		id: "hide-add-btn",
		listeners: {
			change: function(value) {
				if (value) {
					attachActionSettings.hide("add-button-name");
					attachActionSettings.hide("add-icon-name");
					attachActionSettings.hide("attach-action-additional-settings-fs");					
				} else {
					attachActionSettings.show("add-button-name");
					attachActionSettings.show("add-icon-name");
					attachActionSettings.show("attach-action-additional-settings-fs");
				}
			}
		}
	});
	attachActionSettings.addField("add-button-name");
	Attachment.addComboboxIconList("add-icon-name", null, attachActionSettings, null);
	addAttachActionAdditionalSettings(attachActionSettings);
	
	if (attachActionSettings.getValue("hide-add-btn")) {
		attachActionSettings.hide("add-button-name");
		attachActionSettings.hide("add-icon-name");
		attachActionSettings.hide("attach-action-additional-settings-fs");
	} else {
		attachActionSettings.show("add-button-name");
		attachActionSettings.show("add-icon-name");
		attachActionSettings.show("attach-action-additional-settings-fs");
	}
	
};

function addAttachActionAdditionalSettings(settings) {
	var attachActionAdditionalSettings = settings.addFieldSet({
		id: "attach-action-additional-settings-fs",
		collapsible: true,
		collapsed: true,
		title: Attachment.t("action.buttons-for-attachments-in-column.more-document-info")
	});
	Attachment.addComboboxClassList("doc-class-list-name", null, attachActionAdditionalSettings, null,null,false);
	attachActionAdditionalSettings.addField("show-indexes");
	attachActionAdditionalSettings.addField("check-rights");
	attachActionAdditionalSettings.addField("auto-select-first");
	attachActionAdditionalSettings.addField("description");
	attachActionAdditionalSettings.addField("success-msg-add");
};

function addDetachActionSettings(settings) {
	var detachActionSettings = settings.addFieldSet({
		id: "detach-action-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.detach-action-settings")
	});
	
	detachActionSettings.addField({
		id: "hide-detach-btn",
		listeners: {
			change: function(value) {
				if (value) {
					detachActionSettings.hide("detach-button-name");
					detachActionSettings.hide("detach-icon-name");
					detachActionSettings.hide("detach-action-additional-settings-fs");
					
				} else {
					detachActionSettings.show("detach-button-name");
					detachActionSettings.show("detach-icon-name");
					detachActionSettings.show("detach-action-additional-settings-fs");
				}
			}
		}
	});
	detachActionSettings.addField("detach-button-name");
	Attachment.addComboboxIconList("detach-icon-name", null, detachActionSettings, null); 
	addDetachActionAdditionalSettings(detachActionSettings);
	
	if (detachActionSettings.getValue("hide-detach-btn")) {
		detachActionSettings.hide("detach-button-name");
		detachActionSettings.hide("detach-icon-name");
		detachActionSettings.hide("detach-action-additional-settings-fs");
	} else {
		detachActionSettings.show("detach-button-name");
		detachActionSettings.show("detach-icon-name");
		detachActionSettings.show("detach-action-additional-settings-fs");
	}
};

function addDetachActionAdditionalSettings(settings) {
	var detachActionAdditionalSettings = settings.addFieldSet({
		id: "detach-action-additional-settings-fs",
		collapsible: true,
		collapsed: true,
		title: Attachment.t("action.buttons-for-attachments-in-column.more-document-info")
	});	
	detachActionAdditionalSettings.addField("deleteFromArch");
	detachActionAdditionalSettings.addField("remove-row");

	detachActionAdditionalSettings.addField({
		id: "warnDetachAtachments",
		listeners: {
			change: function(value) {
				if (value) {
					detachActionAdditionalSettings.show("detachConfirmTitle");
					detachActionAdditionalSettings.show("detachConfirmMsg");					
				} else {
					detachActionAdditionalSettings.hide("detachConfirmTitle");
					detachActionAdditionalSettings.hide("detachConfirmMsg");
				}
			}
		}
	});
	
	detachActionAdditionalSettings.addField({
		id: "detachConfirmTitle",
		hidden: !detachActionAdditionalSettings.getValue("warnDetachAtachments")
	});
	
	detachActionAdditionalSettings.addField({
		id: "detachConfirmMsg",
		hidden: !detachActionAdditionalSettings.getValue("warnDetachAtachments")
	});
};

function addDownloadActionSettings(settings) {
	var downloadActionSettings = settings.addFieldSet({
		id: "download-action-settings-fs",
		collapsible: true,
		collapsed: false,
		title: Attachment.t("action.buttons-for-attachments-in-column.download-action-settings")
	});
		
	downloadActionSettings.addField({
		id: "hide-download-btn",
		listeners: {
			change: function(value) {
				if (value) {
					downloadActionSettings.hide("download-button-name");
					downloadActionSettings.hide("download-icon-name");
					downloadActionSettings.hide("save-changes-action-settings-fs");
					downloadActionSettings.hide("cancel-changes-action-settings-fs");
				} else {
					downloadActionSettings.show("download-button-name");
					downloadActionSettings.show("download-icon-name");	
					downloadActionSettings.show("save-changes-action-settings-fs");
					downloadActionSettings.show("cancel-changes-action-settings-fs");
				}
			}
		}
	});
	
	downloadActionSettings.addField("download-button-name");
	Attachment.addComboboxIconList("download-icon-name", null, downloadActionSettings, null);
	addSaveChangesActionSettings(downloadActionSettings);
	addCancelChangesActionSettings(downloadActionSettings);
	
	if (downloadActionSettings.getValue("hide-download-btn")) {
		downloadActionSettings.hide("download-button-name");
		downloadActionSettings.hide("download-icon-name");
		downloadActionSettings.hide("save-changes-action-settings-fs");
		downloadActionSettings.hide("cancel-changes-action-settings-fs");
	} 	else {
		downloadActionSettings.show("download-button-name");
		downloadActionSettings.show("download-icon-name");
		downloadActionSettings.show("save-changes-action-settings-fs");
		downloadActionSettings.show("cancel-changes-action-settings-fs");
	}
};

function addSaveChangesActionSettings(settings) {
	var saveChangesActionSettings = settings.addFieldSet({
		id: "save-changes-action-settings-fs",
		collapsible: true,
		collapsed: true,
		title: Attachment.t("action.buttons-for-attachments-in-column.save-changes-action-settings")
	});
	saveChangesActionSettings.addField("save-button-name");
	Attachment.addComboboxIconList("save-icon-name", null, saveChangesActionSettings, null);
};

function addCancelChangesActionSettings(settings) {
	var cancelChangesActionSettings = settings.addFieldSet({
		id: "cancel-changes-action-settings-fs",
		collapsible: true,
		collapsed: true,
		title: Attachment.t("action.buttons-for-attachments-in-column.cancel-changes-action-settings")
	});
	cancelChangesActionSettings.addField("cancel-button-name");
	Attachment.addComboboxIconList("cancel-icon-name", null, cancelChangesActionSettings, null);
};
