PW.FormActions.create('table-detach-all', {
    dtButtonInit: function (button) {
        this.table = VariableSetService.get(button.getVariableSet().getId());
    },

    variableSetInit: function (variableSet) {
        var me = this;
        var func = this.detachAll;
        var table = VariableSetService.get(variableSet.getId());
        var buttonName = this.get("detach-button-name");
        var iconName = this.get("detach-icon-name");

        VariableSetService.addBottomToolbarButton(
            table, {
                itemId: 'detachAllAttachment',
                iconCls: "silk-" + iconName,
                text: buttonName,
                handler: function () {
                    func(me, table);
                }
            });
    },

    defaultActions: {
        dtButton: function() {
            this.detachAll(this, this.table);
        }
    },

    detachAll: function (me, table) {
        var values = me.get("column-file-id").getValue();
        var valueToDetach = [];
        var flagCanDeatach = false;
        for (index = values.length - 1; index >= 0; index--) {
            if (values[index]) {
                flagCanDeatach = true;
                valueToDetach.push(values[index]);
            }
        }
        if (flagCanDeatach) {
            if (me.get("warnDetachAtachments")) {
                MessageService.showConfirm({
                    title: me.get("detachConfirmTitle"),
                    message: me.get("detachConfirmMsg"),
                    yes: function () {
                        var cfg = {
                            success: function (respone) {
                                for (currentRow = VariableSetService.getRowsCount(table) - 1; currentRow >= 0; currentRow--) {
                                    var value = VariableSetService.getValue(table, currentRow, me.get("column-file-id").getId());
                                    var flagCheck = false;
                                    for (index = valueToDetach.length - 1; index >= 0; index--) {
                                        if (valueToDetach[index] == value) {
                                            flagCheck = true;
                                            break;
                                        }
                                    }
                                    if (flagCheck) {
                                        if (me.get("remove-row")) {
                                            table.store.removeAt(currentRow);
                                        } else {
                                            var variables = me.get("clear-cell");
                                            if (variables) {
                                                for (index = 0; index < variables.length; index++) {
                                                    if (variables[index]) {
                                                        VariableSetService.setValue(table, currentRow, variables[index].getId(), null);
                                                    }
                                                }
                                            }
                                            VariableSetService.setValue(table, currentRow, me.get("column-file-id").getId(), null);
                                        }
                                    }
                                }
                                VariableSetService.save(table);
                                FormService.save();
                                CUF.document.core.DocumentView.reloadDocumentsGrid();
                                MessageService.showSuccess(me.get("msgSuccess"));
                            },
                            failure: function (respone) {
                                MessageService.showFailure(me.get("msgError"));
                                logger.error(respone);
                            }
                        };
                        if (me.get("deleteFromArch")) {
                            CUF.DocumentService.deleteDocuments(valueToDetach, cfg);
                        } else {
                            CUF.DocumentService.detachDocuments(valueToDetach, processId, activityId, cfg);
                        }

                    }
                })
            } else {
                var cfg = {
                    success: function (respone) {
                        for (currentRow = VariableSetService.getRowsCount(table) - 1; currentRow >= 0; currentRow--) {
                            var value = VariableSetService.getValue(table, currentRow, me.get("column-file-id").getId());
                            var flagCheck = false;
                            for (index = valueToDetach.length - 1; index >= 0; index--) {
                                if (valueToDetach[index] == value) {
                                    flagCheck = true;
                                    break;
                                }
                            }
                            if (flagCheck) {
                                if (me.get("remove-row")) {
                                    table.store.removeAt(currentRow);
                                } else {
                                    var variables = me.get("clear-cell");
                                    if (variables) {
                                        for (index = 0; index < variables.length; index++) {
                                            if (variables[index]) {
                                                VariableSetService.setValue(table, currentRow, variables[index].getId(), null);
                                            }
                                        }
                                    }
                                    VariableSetService.setValue(table, currentRow, me.get("column-file-id").getId(), null);
                                }
                            }
                        }
                        VariableSetService.save(table);
                        FormService.save();
                        CUF.document.core.DocumentView.reloadDocumentsGrid();
                        MessageService.showSuccess(me.get("msgSuccess"));
                    },
                    failure: function (respone) {
                        MessageService.showFailure(me.get("msgError"));
                        logger.error(respone);
                    },
                }
                if (me.get("deleteFromArch")) {
                    CUF.DocumentService.deleteDocuments(valueToDetach, cfg);
                } else {
                    CUF.DocumentService.detachDocuments(valueToDetach, processId, activityId, cfg);
                }
            }
        } else {
            MessageService.showFailure(me.get("msgDocNotAttach"));
        }
    }
});