PW.FormActions.create('attachment.actions.deleteAttachmentAction', {

    dtButtonInit: function (dtButton) {
        this.conditionFn = this.get("condition");
        this.deleteFromArchive = this.get("deleteFromArchive");
        this.variableSet = dtButton.getVariableSet();
    },

    defaultActions: {
        dtButton: function() {
            let settings = {};
            let table = VariableSetService.get(this.variableSet.getId())
            settings["columnFileId"] = this.get("columnFileId");
            settings["messageWarning"] = this.get("messageWarning");
            this.deleteAttachment(table, settings);
        },
    },

    deleteAttachment: function (table, settings) {
        let selectedRow = VariableSetService.getSelected(table);
        if (selectedRow == null) {
            MessageService.show(settings["messageWarning"]);
            return;
        }
        let rowIndex = VariableSetService.getRowIndex(table, selectedRow);
        let fileId = selectedRow.data[settings["columnFileId"].getId()];

        if (this.conditionFn) {
            this.setContextVariable("currentRow", rowIndex);
            if (!this.conditionFn.call()) {
                return;
            }
        }
        let me = this;
        MessageService.showConfirm({
            title: this.deleteFromArchive ? Attachment.t('attachment.actions.deleteAttachmentAction.deleteFromArchive.title')
                : Attachment.t('attachment.actions.deleteAttachmentAction.showConfirm.window.title'),
            message: this.deleteFromArchive ? Attachment.t('attachment.actions.deleteAttachmentAction.deleteFromArchive.message')
                : Attachment.t('attachment.actions.deleteAttachmentAction.showConfirm.window.message'),
            yes: function () {
                if (me.deleteFromArchive) {
                    CUF.DocumentService.deleteDocuments(fileId, {
                        success: function (response) {
                            table.store.removeAt(rowIndex);
                            DocumentService.refreshDocuments();
                            ServiceFactory.getFormService().save();
                        },
                        failure: function (response) {
                            MessageService.showError(Attachment.t('attachment.actions.deleteAttachmentAction.deleteFromArchive.error'));
                            Logger.error(response);
                        },
                    })
                } else {
                    table.store.removeAt(rowIndex);
                    let activityId = ServiceFactory.getActivityInfoService().getActivityId();
                    let processId = ServiceFactory.getActivityInfoService().getProcessId();
                    CUF.DocumentService.detachDocument(fileId, processId, activityId, {
                        success: function () {
                            DocumentService.refreshDocuments();
                        },
                    });
                    let formService = ServiceFactory.getFormService();
                    formService.save();
                }
            }
        })
    }
});