/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.controller;

import com.suncode.plugin.attachment.enums.DocumentParameters;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.SilkIconPack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class DocumentInfoController {
    private static final Logger log = LoggerFactory.getLogger(DocumentInfoController.class);
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentService docService;

    @RequestMapping(value={"docid/{fileid}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getDocId(@PathVariable(value="fileid") Long fileId) {
        log.debug("GetDocID  from file id\t:" + fileId);
        DocumentService docService = ServiceFactory.getDocumentService();
        WfDocument document = docService.getDocument(fileId);
        if (document != null) {
            Long docId = document.getId();
            return docId.toString();
        }
        return "";
    }

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<Map> docClassInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClass documentClass : classes) {
            HashMap<String, String> docClassInfo = new HashMap<String, String>();
            docClassInfo.put("docClassId", documentClass.getId().toString());
            docClassInfo.put("docClassName", documentClass.getName());
            docClassInfo.put("docClassDesc", documentClass.getDescription());
            tempList.add(docClassInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docClassId")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassInfoList.add(map);
            }
        }
        int totalResult = docClassInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"icon"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentIconList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> resultList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        HashMap<String, String> iconInfo = new HashMap<String, String>();
        for (SilkIconPack silkIcon : SilkIconPack.values()) {
            iconInfo = new HashMap();
            iconInfo.put("iconName", silkIcon.getCss().substring(5));
            tempList.add(iconInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            resultList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("iconName")).toLowerCase().contains(query.toLowerCase())) continue;
                resultList.add(map);
            }
        }
        int totalResult = resultList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(resultList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(resultList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"docClassIndexList/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassIndexList(@PathVariable(value="className") String className, @RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        DocumentClass temp = this.docClassService.getDocumentClass(className, new String[]{"indexes"});
        try {
            if (temp == null) {
                temp = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(className)), new String[]{"indexes"});
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            ArrayList dataError = new ArrayList();
            HashMap<String, String> errorResult = new HashMap<String, String>();
            errorResult.put("docClassIndexId", "");
            errorResult.put("docClassIndexName", "");
            errorResult.put("docClassIndexDesc", e.getMessage());
            errorResult.put("docClassIndexType", "Server error");
            dataError.add(errorResult);
            result.setData(dataError);
            return result;
        }
        Set indexes = temp.getIndexes();
        ArrayList<Map> docClassIndexInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClassIndex documentClassIndex : indexes) {
            HashMap<String, String> docClassindexInfo = new HashMap<String, String>();
            docClassindexInfo.put("docClassIndexId", documentClassIndex.getId().toString());
            docClassindexInfo.put("docClassIndexName", documentClassIndex.getName());
            docClassindexInfo.put("docClassIndexDesc", documentClassIndex.getDescription());
            docClassindexInfo.put("docClassIndexType", documentClassIndex.getType().toString());
            tempList.add(docClassindexInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassIndexInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassIndexName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docClassIndexId")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassIndexInfoList.add(map);
            }
        }
        int totalResult = docClassIndexInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassIndexInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassIndexInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"docParamList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentParamList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> docParamList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentParameters docParameter : DocumentParameters.values()) {
            HashMap<String, String> docParamInfo = new HashMap<String, String>();
            docParamInfo.put("docParamName", docParameter.getName());
            docParamInfo.put("docParamKey", docParameter.getKey());
            tempList.add(docParamInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docParamList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docParamName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docParamKey")).toLowerCase().contains(query.toLowerCase())) continue;
                docParamList.add(map);
            }
        }
        int totalResult = docParamList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docParamList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docParamList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    private List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }
}

