window.Attachment = {
	t: PW.I18N.createT('com.suncode.plugin-attachment'),
	addComboboxClassList : function(idName, listenersFn, form, position, optionalParam, hiddenParam, forceSelectionParam) {
		form.addCombobox({
			id : idName,
			hidden : (hiddenParam == null) ? true : hiddenParam,
			optional : (optionalParam == null) ? true : optionalParam,
			forceSelection : (forceSelectionParam == null) ? true : forceSelectionParam,
			remote: {
				url: "plugin/com.suncode.plugin-attachment/api/docClassList",
				fields: [
					{
						name: "docClassId",
						type: "string"
					},
					{
						name: "docClassName",
						type: "string"
					},
					{
						name: "docClassDesc",
						type: "string"
					}
				]
			},
			template: [
				{
					label: Attachment.t("dpwe-doc-class.name"),
					field: "docClassName"
				},
				{
					label: Attachment.t("dpwe-doc-class.desc"),
					field: "docClassDesc"
				},
				{
					label: Attachment.t("dpwe-doc-class.id"),
					field: "docClassId"
				}
			],
			valueField: "docClassName",
			displayField: "docClassName",
			sort: [{
				property: "docClassName",
				direction: "ASC"
			}],
			listeners: listenersFn
		}, position)
	},
	addComboboxDocParamList: function(idName, listenersFn, form, position) {
		form.addCombobox({
			id: idName,
			remote: {
				url: "plugin/com.suncode.plugin-attachment/api/docParamList",
				fields: [
					{
						name: "docParamName",
						type: "string"
					},
					{
						name: "docParamKey",
						type: "string"
					}
				]
			},
			template: [
				{
					label: Attachment.t("dpwe-doc-param.name"),
					field: "docParamName"
				}
			],
			valueField: "docParamKey",
			displayField: "docParamName",
			sort: [{
				property: "docParamName",
				direction: "ASC"
			}],
			listeners: listenersFn
		}, position)
	},
	addComboboxIconList: function(idName, listenersFn, form, position) {
		form.addCombobox({
			id: idName,
			optional: true,
			remote: {
				url: "plugin/com.suncode.plugin-attachment/api/icon",
				fields: [
					{
						name: "iconName",
						type: "string"
					},
				]
			},

			valueField: "iconName",
			displayField: "iconName",
			sort: [{
				property: "iconName",
				direction: "ASC"
			}],
			listeners: listenersFn
		}, position)
	},
	addComboboxClassIndexList: function(idName, className, listenersFn, form, position) {
		if (className != undefined) {
			form.addCombobox({
				id: idName,
				remote: {
					url: "plugin/com.suncode.plugin-attachment/api/docClassIndexList/" + className,
					fields: [
						{
							name: "docClassIndexId",
							type: "string"
						},
						{
							name: "docClassIndexName",
							type: "string"
						},
						{
							name: "docClassIndexDesc",
							type: "string"
						},
						{
							name: "docClassIndexType",
							type: "string"
						}
					]
				},
				template: [
					{
						label: Attachment.t("dpwe-doc-class-index.name"),
						field: "docClassIndexName"
					},
					{
						label: Attachment.t("dpwe-doc-class-index.desc"),
						field: "docClassIndexDesc"
					},
					{
						label: Attachment.t("dpwe-doc-class-index.type"),
						field: "docClassIndexType"
					},
					{
						label: Attachment.t("dpwe-doc-class-index.id"),
						field: "docClassIndexId"
					}
				],
				valueField: "docClassIndexName",
				displayField: "docClassIndexName",
				sort: [{
					property: "docClassIndexName",
					direction: "ASC"
				}],
				listeners: listenersFn
			}, position);
		}
		else {
			form.addField({
				id: idName,
				listeners: listenersFn
			}, position);
		}
	},

	addComboboxClassIndexListWithDynamicUrl: function(idName, table, form, docClassNameId) {
		table.addCombobox({
			id: idName,
			remote: {
				url: function(options) {
					var className = form.getValue(docClassNameId)[options.rowIndex];
					return "plugin/com.suncode.plugin-attachment/api/docClassIndexList/" + className
				},
				fields: [
					{
						name: "docClassIndexId",
						type: "string"
					},
					{
						name: "docClassIndexName",
						type: "string"
					},
					{
						name: "docClassIndexDesc",
						type: "string"
					},
					{
						name: "docClassIndexType",
						type: "string"
					}
				]
			},
			template: [
				{
					label: Attachment.t("dpwe-doc-class-index.name"),
					field: "docClassIndexName"
				},
				{
					label: Attachment.t("dpwe-doc-class-index.desc"),
					field: "docClassIndexDesc"
				},
				{
					label: Attachment.t("dpwe-doc-class-index.type"),
					field: "docClassIndexType"
				},
				{
					label: Attachment.t("dpwe-doc-class-index.id"),
					field: "docClassIndexId"
				}
			],
			valueField: "docClassIndexName",
			displayField: "docClassIndexName",
			sort: [{
				property: "docClassIndexName",
				direction: "ASC"
			}]
		});
	},

	resetColumnValue: function(id, form) {
		arraySize = form.getArraySize(id);
		for (pos = 0; pos < arraySize; pos++) {
			form.setFieldValueInArray(id, pos, "");
		}
	},
	validateVariableArrayValue: function(api, parameterId) {
		var validateFlag = true;
		for (i = 0; i < api.getArraySize(parameterId); i++) {
			if (!api.hasVariableArrayValue(parameterId, i)) {
				api.markError(parameterId, i);
				validateFlag = false;
			}
		}
		return validateFlag;
	},
	validateEmptyArrayValue: function(api, parameterId) {
		var validateFlag = true;
		for (i = 0; i < api.getArraySize(parameterId); i++) {
			if (!api.getValue(parameterId)[i]) {
				api.markError(parameterId, i);
				validateFlag = false;
			}
		}
		return validateFlag;
	}
};