PWE.integrationComponent.registerFormAction('read-document-infos-action', {
	apiVersion: 2,
	buildForm: function(form) {
		form.addField("fileIdColumnVar");
		var indexTable = form.addTable({
			id: "indexTable",
			name: Attachment.t("dpwe.indexTable.name"),
		});

		Attachment.addComboboxClassList("docClassName", {
			change: function(value, options) {
				form.setFieldValueInArray("indexName", options.rowIndex, "");
			}
		}, indexTable, null, false);
		Attachment.addComboboxClassIndexListWithDynamicUrl("docIndexesArray", indexTable, form, "docClassName");

		form.show("docClassName");

		indexTable.addField({
			id: "docIndexNameVar"
		});

		var tableParam = form.addTable({
			id: 'tableParam',
			name: Attachment.t("dpwe.docParamTable.name"),
		});
		Attachment.addComboboxDocParamList("docParam", null, tableParam, null);
		tableParam.addField('docParamVar');

		var tableConst = form.addTable({
			id: 'tableConst',
			name: Attachment.t("dpwe.constTable.name"),
		});
		tableConst.addField('constParam');
		tableConst.addField('constParamVar');
	}
});