PWE.integrationComponent.registerApplication("attachment.applications.MergePDFFiles", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form)
});

PWE.integrationComponent.registerVariablesSetter("attachment.applications.MergePDFFiles", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form)
});

function buildForm(form) {
    form.addField("outputFileId");
    form.addField("inputFileIdArray");
    form.addField("executeDocumentClassActions");

    form.addCombobox({
        id: "documentClassName",
        forceSelection: false,
        remote: {
            url: "plugin/com.suncode.plugin-attachment/api/docClassList",
            fields: [
                {
                    name: "docClassId",
                    type: "string"
                },
                {
                    name: "docClassName",
                    type: "string"
                },
                {
                    name: "docClassDesc",
                    type: "string"
                }
            ]
        },
        template: [
            {
                label: Attachment.t("dpwe-doc-class.name"),
                field: "docClassName"
            },
            {
                label: Attachment.t("dpwe-doc-class.desc"),
                field: "docClassDesc"
            },
            {
                label: Attachment.t("dpwe-doc-class.id"),
                field: "docClassId"
            }
        ],
        valueField: "docClassName",
        displayField: "docClassName",
        sort: [{
            property: "docClassName",
            direction: "ASC"
        }]
    });

    form.addField("outputFilename");
    form.addField("outputFileDescription");
    form.addField("addToProcess");
}