PWE.integrationComponent.registerFormAction('attachment-table-multi-manager', {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField("manager-column");
        form.addField("manager-button-name");
        form.addField({
            id: "hide-add-btn",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("doc-class-name");
                        form.hide("show-indexes");
                        form.hide("check-rights");
                        form.hide("auto-select-first");
                    } else {
                        form.show("doc-class-name");
                        form.show("show-indexes");
                        form.show("check-rights");
                        form.show("auto-select-first");
                    }
                }
            }
        });

        Attachment.addComboboxClassList("doc-class-name", null, form, null);

        form.addField("show-indexes");
        form.addField("check-rights");
        form.addField("auto-select-first");
        form.addField({
            id: "hide-deatch-btn",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("warning-detach");
                        form.hide("remove-from-archive");
                        form.hide("detach-mode");
                    } else {
                        form.show("warning-detach");
                        form.show("remove-from-archive");
                        form.show("detach-mode");
                    }
                }
            }
        });
        form.addField({
            id: "deatch-owner",
            hidden: true
        });
        form.addCombobox({
            id: "detach-mode",
            values: [
                {id: "OWN_DOCUMENT", display: Attachment.t("dpwe.detach-mode.own-document")},
                {id: "ARCHIVE_GRANT", display: Attachment.t("dpwe.detach-mode.archive-grant")},
                {id: "NOT_ALLOWED", display: Attachment.t("dpwe.detach-mode.not-allowed")}
            ],
            valueField: "id",
            displayField: "display",
            listeners: {
                afterrender: function () {
                    if (!form.getValue("detach-mode")) {
                        let detachMode = form.getValue("deatch-owner") ? "OWN_DOCUMENT" : "NOT_ALLOWED";
                        form.setValue("detach-mode", detachMode);
                    }
                }
            }
        });
        form.addField("warning-detach");
        form.addField("remove-from-archive");
        form.addField("hide-show-btn");
        form.addCombobox({
            id: "hide-col",
            value: "empty",
            values: [
                {
                    id: "empty",
                    display: ""
                },
                {
                    id: "col-desc",
                    display: Attachment.t("dpwe-multi-combox-col-desc")
                },
                {
                    id: "col-docclassname",
                    display: Attachment.t("dpwe-multi-combox-col-docclassname")
                },
                {
                    id: "col-date",
                    display: Attachment.t("dpwe-multi-combox-col-date")
                },
                {
                    id: "col-filesize",
                    display: Attachment.t("dpwe-multi-combox-col-filesize")
                },
                {
                    id: "col-uploder",
                    display: Attachment.t("dpwe-multi-combox-col-uploder")
                },
                {
                    id: "col-info",
                    display: Attachment.t("dpwe-multi-combox-col-info")
                }
            ]
        });

        if (form.getValue("hide-deatch-btn")) {
            form.hide("warning-detach");
            form.hide("remove-from-archive");
            form.hide("detach-mode");
        } else {
            form.show("warning-detach");
            form.show("remove-from-archive");
            form.show("detach-mode");
        }

        if (form.getValue("hide-add-btn")) {
            form.hide("doc-class-name");
            form.hide("show-indexes");
            form.hide("check-rights");
            form.hide("auto-select-first");
        } else {
            form.show("doc-class-name");
            form.show("show-indexes");
            form.show("check-rights");
            form.show("auto-select-first");
        }
        form.addField("condition");
    },

    validateForm: function (api) {
        if (api.hasFunctionValue('condition') && 'boolean' !== api.getFunctionReturnType('condition')) {
            api.markError('condition');
            api.showErrorMessage(Attachment.t('attachment-table-multi-manager.form-valid-function-boolean'));
            return false;
        }
    }
});