var variableService = ServiceFactory.getVariableService();
var messageService = ServiceFactory.getMessageService();
var variableSetService = ServiceFactory.getVariableSetService();

PW.FormActions.create('table-show-attachment', {

    init: function() {
        this.settings = {};
        this.settings["column-file-id"] = this.get("column-file-id");
        this.settings["msg-warning"] = this.get("msg-warning");
    },

    dtButtonInit: function (button) {
        this.table = variableSetService.get(button.getVariableSet().getId());
    },

    variableSetInit: function (variableSet) {

        var func = this.showButtonFunc;

        var buttonName = this.get("button-name");
        var iconName = this.get("icon-name");
        var table = variableSetService.get(variableSet.getId());

        variableSetService.addBottomToolbarButton(
            table, {
        	itemId:'showAttachment',
                iconCls: "silk-" + iconName,
                text: buttonName,
                handler: () => {
                    func(table, this.settings);
                }
            });
    },

    defaultActions: {
        dtButton: function(){
            this.showButtonFunc(this.table, this.settings);
        }
    },

    showButtonFunc: function (table, settings) {
        var selectedRow = variableSetService.getSelected(table);
        if (selectedRow == null) {
            messageService.show(settings["msg-warning"]);
            return;
        }
        var fileId = selectedRow.data[settings["column-file-id"].getId()];
        if (!fileId) {
            return;
        }
        CUF.DocumentService.showFile(parseInt(fileId));
        return true;
    }
});