var variableService = ServiceFactory.getVariableService();
var messageService = ServiceFactory.getMessageService();
var vss = ServiceFactory.getVariableSetService();

PW.FormActions.create('table-show-attachment-column', {
    variableSetInit: function (table) {
        this.table = vss.get(table.getId());
        this.tableId = table.getId();
    },

    enable: function () {
        this.initButtonFun();
        var me = this;
        vss.addRenderer(this.table, function (value, data, column, metaData) {
            metaData.encode = false;
            var div = jQuery("<div/>");
            div.append(me.createShowButton(value, data, column, metaData));
            return div.html();

        }, [this.get("column").getId()]);
    },
    disable: function () {
        vss.removeRenderers(this.table, [this.get("column").getId()]);
    },
    createShowButton: function (value, data, column, metaData) {
        var fileid = data[this.get('column-file-id').getId()]
        button = this.buildTamplateButton();
        if (this.get("msg") && !(fileid)) {
            button.attr('onClick', 'MessageService.showFailure(\"'
                + this.get("msg")
                + '\")');
        } else {
            button.attr('onClick', 'Attachment.showDocument("' + fileid + '")');
        }
        button.append(this.createIconSpan('zoom'));
        button.append(this.createNameSpan(this.get('button-name')));
        return button;
    },
    createIconSpan: function (icon) {
        span = jQuery("<span/>");
        span.addClass("x4-btn-icon-el")
        span.addClass("silk-" + icon)
        span.css("margin-left", "5px");
        span.text(" ")
        return span;
    },

    createNameSpan: function (name) {
        let span = jQuery("<span/>");
        span.addClass("x4-btn-inner")
        span.addClass("x4-btn-inner-center")
        span.css("margin-left", "5px");
        span.append(name)
        return span;
    },
    buildTamplateButton: function () {
        let button = jQuery("<button/>");
        button.addClass("x4-btn")
        button.addClass("x4-btn-default-small-icon-text-left")

        button.attr('style', 'width: 96% !important;')
        button.css("line-height", "16px");
        button.css("padding", "0px");

        return button;
    },
    initButtonFun: function () {
        Attachment.showDocument = this.showDocument;
    },
    showDocument: function (fileId) {
        CUF.DocumentService.showFile(parseInt(fileId));
    }
});