if (Ext4.isIE) {
    var pasteCatcher = jQuery('<div class="contenteditable" contenteditable="true" style="width: 0px;height: 0px;position: absolute;top: -5000px;"></div>');
    pasteCatcher.appendTo('body');
}
PW.FormActions.create('attachments.table-paste-image', {
    variableSetInit: function (table) {
        this.table = table;
        this.tableId = table.getId();
        this.initEvent();
    },
    enable: function () {
        this.enableOn = true;
    },
    disable: function () {
        this.enableOn = false;
    },
    initEvent: function () {
        var me = this;
        if (Ext4.isIE) {
            pasteCatcher[0].addEventListener('paste', me.onPasteEvent.bind(me), false);
            me.table.grid.el.dom.addEventListener("keydown", function (event) {
                if (event.ctrlKey && event.keyCode == 86) {
                    me.scrollPosition = { x: window.pageXOffset, y: window.pageYOffset };
                    pasteCatcher.focus();
                }
            });
        }

        me.table.grid.el.dom.addEventListener("paste", me.onPasteEvent.bind(me), false);
    },

    onPasteEvent: function (pasteEvent) {
        var me = this;
        if (me.scrollPosition) {
            window.scrollTo(me.scrollPosition.x, me.scrollPosition.y);
        }
        if (me.enableOn) {
            var currentRecord = VariableSetService.getSelected(me.table.grid);
            if (currentRecord) {
                currentRow = VariableSetService.getRowIndex(me.table.grid, currentRecord);


                var fileId = me.table.getVariable(me.get("columnFileId").getId()).getValueAt(currentRow);
                if (fileId) {
                    MessageService.showFailure(me.get("msgDocAttach"))
                    return
                }
                var imageInClipboard = false;
                var blob;
                var files = new Object();
                if (Ext4.isEdge) {
                    var items = pasteEvent.clipboardData.items;
                    for (var i = 0; i < items.length; i++) {
                        if (items[i].type.indexOf("image") == 0) {
                            blob = items[i].getAsFile();
                            break;
                        }
                    }
                    files[0] = blob;
                    files.length = 1;
                    imageInClipboard = true;
                } else {
                    files = window.clipboardData ? window.clipboardData.files : pasteEvent.clipboardData.files;
                    files = jQuery.extend(true, {}, files);
                    for (var i = 0; i < files.length; i++) {
                        if (files[i].type.indexOf("image") == 0) {
                            imageInClipboard = true;
                            break;
                        }
                    }
                }
                if (!imageInClipboard) {
                    MessageService.showFailure(me.get("msgNoImageInClibboard"))
                    return;
                } else {
                    pasteEvent.preventDefault();
                    me.cfg = new Object();
                    me.cfg.filesList = files;
                    me.cfg.currentRow = currentRow;
                    me.cfg.me = me;
                    me.cfg.url = URL.createObjectURL(me.cfg.filesList[0]);
                    if (!me.imagePreviewWindow) {
                        me.createImagePreviewWindow();
                    }
                    me.imagePreviewWindow.updateImage(me.cfg.url);
                    me.imagePreviewWindow.center();
                    me.imagePreviewWindow.show();
                }
            } else {
                Logger.error("No row selected")
            }
        }
    },

    pasteImage: function (cfgSend) {
        var me = cfgSend.me;
        var filesList = cfgSend.filesList;
        var fileName = cfgSend.fileName;
        var currentRow = cfgSend.currentRow;
        var desc = cfgSend.desc;
        if (me.get("showAddDocForm")) {
            var docList = me.get("docClassListName");
            var fileNames = [];
            fileNames[0] = fileName;
            var cfg = {
                showIndexes: me.get("showIndexes"),
                checkRights: me.get("checkRights"),
                autoSelectFirst: me.get("autoSelectFirst"),
                documentClassNameList: (docList && docList[0]) ? docList : undefined,
                callback: function (files) {
                    me.saveFileData(files[0], currentRow, me);
                    if (me.get("columnFileClassName")) {
                        VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileClassName").getId(), files[0].documentClass.name);
                    }
                    FormService.save();
                    MessageService.showSuccess(me.get("msgSuccessAdd"));
                    FormService.refreshDocuments()
                    if (cfgSend.isPrevimgWindow) { me.closeWindow() }
                },
                files: filesList,
                fileNames: fileNames,
                fileDescription: desc
            };
            CUF.DocumentService.showAddDocumentsFromDiscForm(cfg);
        }
        else {
            me.sendFiles(cfgSend);
        }
    },
    sendFiles: function (cfgSend) {
        var files = cfgSend.filesList
        var currentRow = cfgSend.currentRow;
        var me = cfgSend.me;
        var cfg = new Object();
        cfg.userName = Suncode.getCurrentUser();
        cfg.documentClassName = me.get("documentClassName");
        cfg.processId = processId;
        cfg.activityId = activityId;
        cfg.indexes = me.getIndexes(me);
        cfg.description = cfgSend.desc;
        cfg.fileName = cfgSend.fileName;
        cfg.saveAsNewVersion = me.get("saveAsNewVersion") == undefined ? false : me.get("saveAsNewVersion");

        FormService.mask();
        var formData = new FormData();
        for (var i = 0, f; f = files[i]; i++) {
            formData.append('files', files[i]);
        }


        formData.append('cfg', JSON.stringify(cfg));
        jQuery.ajax({
            url: 'plugin/com.suncode.plugin-attachment/api/docs/upload',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.success) {
                    me.saveFileData(data.files[0], currentRow, me);
                    if (me.get("columnFileClassName")) {
                        VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileClassName").getId(), cfg.documentClassName);
                    }
                    FormService.save();
                    MessageService.showSuccess(me.get("msgSuccessAdd"));

                } else {
                    FormService.unmask();
                    Logger.error(data.message);
                    MessageService.showFailure(data.message);
                }
            },
            error: function (error) {
                FormService.unmask();
                MessageService.showFailure("Request error");
                Logger.error(error);
            },
            complete: function () {
                FormService.unmask();
                if (cfgSend.isPrevimgWindow) {
                    me.closeWindow();
                }
                FormService.refreshDocuments()
            }
        });
    },
    saveFileData: function (file, currentRow, me) {
        if (me.get("columnFileId")) {
            VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileId").getId(), file.id);
        }
        if (me.get("columnFileDate")) {
            VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileDate").getId(), (new Date(file.fileDate)).toISOString().replace("T", " ").substring(0, 19));
        }
        if (me.get("columnDocId")) {
            var filetemp = -1;
            jQuery.ajax({
                url: 'plugin/com.suncode.plugin-attachment/api/docid/' + file.id,
                type: "GET",
                async: false,
                success: function (docId) {
                    filetemp = docId;
                    return true;
                },
                error: function () {
                    Logger.error("request error");
                    return false;
                }
            });
            VariableSetService.setValue(me.table.grid, currentRow, me.get("columnDocId").getId(), filetemp);
        }
        if (me.get("columnFileName")) {
            VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileName").getId(), file.fileName);
        }
        if (me.get("columnFileDescripton")) {
            VariableSetService.setValue(me.table.grid, currentRow, me.get("columnFileDescripton").getId(), file.description);
        }

    },
    getIndexes: function (me) {
        var result = new Object();
        var indexName = me.get('indexesName');
        if (me.get("indexesName") == undefined) {
            return undefined;
        }
        var indexesValue = me.get('indexesValue');
        PW.each(indexName, function (item, index) {
            if (index < indexesValue.length) {
                result[item] = indexesValue[index] != null ? indexesValue[index] : null;
            }
        });
        return result;
    },
    createImagePreviewWindow: function () {
        var me = this;
        var imagePreviewWindowDef = Ext4.define('Attachments.preview.iamge.window', {

            extend: 'Ext4.window.Window',
            width: screen.availWidth / 3,
            layout: 'fit',
            modal: true,
            buttonAlign: 'right',
            closable: false,

            title: Attachment.t("form-pasteImageWindow.title"),

            items: [{
                xtype: 'form',
                frame: false,
                border: 0,

                layout: {
                    type: 'vbox',
                    align: 'stretch '
                },

                items: [{
                    xtype: 'container',
                    flex: 1,
                    width: '100%',
                    height: screen.availHeight / 3,
                    items: [
                        {
                            xtype: 'panel',
                            itemId: 'prevImgWindow',
                            bodyPadding: 10,
                            height: screen.availHeight / 3,
                            border: 0

                        }]
                }, {
                    xtype: 'textfield',
                    fieldLabel: Attachment.t("form-pasteImageWindow.labelName"),
                    itemId: 'nameField',
                    allowBlank: false,
                    margin: '0 20 10 20',
                    width: '100%',
                    value: 'image.png'
                }, {
                    xtype: 'textfield',
                    fieldLabel: Attachment.t("form-pasteImageWindow.labelDescription"),
                    itemId: 'descriptionField',
                    allowBlank: true,
                    margin: '0 20 10 20',
                    width: '100%'
                }],

                buttons: [{
                    text: Attachment.t("form-pasteImageWindow.buttonPaste"),
                    itemId: 'acceptButton',
                    handler: function () {
                        var isValid = this.up('window').down('form').getForm().isValid();
                        if (isValid) {
                            me.cfg.desc = this.up('window').queryById('descriptionField').getValue();
                            me.cfg.fileName = this.up('window').queryById('nameField').getValue();
                            me.cfg.isPrevimgWindow = true;;
                            me.pasteImage(me.cfg);
                        }
                    },
                },
                {
                    text: Attachment.t("form-pasteImageWindow.buttonCancel"),
                    itemId: 'cancelButton',
                    handler: this.closeWindow,
                    scope: me
                }],
            }],
            updateImage: function (src) {
                this.queryById('prevImgWindow').update('<div style="vertical-align:middle;"><img src="' + src + '" style="max-height:90%; max-width:90%;display: block; margin: auto"/></div>');
            },

        });
        this.imagePreviewWindow = Ext4.create('Attachments.preview.iamge.window');
    },
    closeWindow: function () {
        this.imagePreviewWindow.hide();
    },
});