PW.FormActions.create('table-delete-attachment', {
    init: function () {
        this.conditionFn = this.get("condition");
        this.deleteFromArchive = this.get("delete-from-archive");
    },

    variableSetInit: function (variableSet) {
        this.table = VariableSetService.get(variableSet.getId());
    },

    enable: function () {
        if (this.target.type === 'VARIABLESET') {
            let me = this;
            let buttonName = this.get("button-name");
            let iconName = this.get("icon-name");
            let table = this.table;
            let settings = {}
            settings["column-file-id"] = this.get("column-file-id");
            settings["msg-warning"] = this.get("msg-warning");

            VariableSetService.addBottomToolbarButton(
                table, {
                    itemId: 'deleteAttachment',
                    iconCls: "silk-" + iconName,
                    text: buttonName,
                    handler: function () {
                        me.deleteButtonFunc(me, table, settings);
                    }
                }
            );
        }
    },

    disable: function () {
        if (this.target.type === 'VARIABLESET') {
            VariableSetService.removeBottomToolbarButton(this.table, 'deleteAttachment');
        }
    },

    dtButtonInit: function (dtButton) {
        this.variableSet = dtButton.getVariableSet();
    },

    defaultActions: {
        dtButton: function () {
            let settings = {};
            let table = VariableSetService.get(this.variableSet.getId())
            settings["column-file-id"] = this.get("column-file-id");
            settings["msg-warning"] = this.get("msg-warning");
            this.deleteButtonFunc(this, table, settings);
        },
    },

    deleteButtonFunc: function (me, table, settings) {
        let selectedRow = VariableSetService.getSelected(table);
        if (selectedRow == null) {
            MessageService.show(settings["msg-warning"]);
            return;
        }
        let rowIndex = VariableSetService.getRowIndex(table, selectedRow);
        let fileId = selectedRow.data[settings["column-file-id"].getId()];

        if (me.conditionFn) {
            me.setContextVariable("current-row", rowIndex);
            if (!me.conditionFn.call()) {
                return;
            }
        }

        MessageService.showConfirm({
            title: me.deleteFromArchive
                ? Attachment.t('action.table-delete-attachment.deleteFromArchive.title')
                : Attachment.t('action.table-delete-attachment.showConfirm.window.title'),
            message: me.deleteFromArchive
                ? Attachment.t('action.table-delete-attachment.deleteFromArchive.message')
                : Attachment.t('action.table-delete-attachment.showConfirm.window.message'),
            yes: function () {
                if (me.deleteFromArchive) {
                    CUF.DocumentService.deleteDocuments(fileId, {
                        success: function (response) {
                            table.store.removeAt(rowIndex);
                            DocumentService.refreshDocuments();
                            ServiceFactory.getFormService().save();
                        },
                        failure: function (response) {
                            MessageService.showError(Attachment.t('action.table-delete-attachment.deleteFromArchive.error'));
                            Logger.error(response);
                        },
                    })
                } else {
                    table.store.removeAt(rowIndex);

                    let activityId = ServiceFactory.getActivityInfoService().getActivityId();
                    let processId = ServiceFactory.getActivityInfoService().getProcessId();

                    CUF.DocumentService.detachDocument(fileId, processId, activityId, {
                        success: function () {
                            DocumentService.refreshDocuments();
                        },
                    });

                    let formService = ServiceFactory.getFormService();
                    formService.save();
                }
            }
        })
    }
});