/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.utils;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.dbspecific.NativeSql;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.search.GroupIndexFilter;
import com.suncode.pwfl.archive.search.IndexFilter;
import com.suncode.pwfl.archive.search.SimpleIndexFilter;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.sql.SQLFilter;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConverter {
    private static final Logger log = LoggerFactory.getLogger(DataConverter.class);
    public static final DateTimeZone jodaTzUTC = DateTimeZone.forID((String)"UTC");

    public static Object stringToObject(String value, Type<?> type) throws IllegalArgumentException {
        if (type == Types.STRING) {
            return value;
        }
        if (type == Types.BOOLEAN) {
            return StringUtils.isBlank((String)value) ? false : value.toLowerCase().equals("true") || value.equals("1");
        }
        if (type == Types.FLOAT) {
            return StringUtils.isBlank((String)value) ? 0.0 : Double.parseDouble(value);
        }
        if (type == Types.INTEGER) {
            return StringUtils.isBlank((String)value) ? 0L : Long.parseLong(value);
        }
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (type == Types.DATE) {
            return new LocalDate((Object)value);
        }
        if (type == Types.DATETIME) {
            return LocalDateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (type == Types.FLOAT_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            Double[] valuesArray = new Double[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = Double.parseDouble(stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.INTEGER_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            Long[] valuesArray = new Long[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = Long.parseLong(stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.DATE_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            LocalDate[] valuesArray = new LocalDate[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = StringUtils.isBlank((String)stringValuesArray[i]) || stringValuesArray[i].equalsIgnoreCase("null") ? null : new LocalDate((Object)stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.STRING_ARRAY) {
            return DataConverter.getStringArray(value);
        }
        throw new IllegalArgumentException("Unknown type to convert: " + type.name());
    }

    private static String[] getStringArray(String value) {
        return value.equals("") ? new String[]{} : value.split(";");
    }

    public static Object indexConverter(String stringValue, IndexType indexType) {
        switch (indexType) {
            case DATE: {
                return DataConverter.localdateToDate(new LocalDate((Object)stringValue));
            }
            case DATETIME: {
                LocalDateTime localDateTime = LocalDateTime.parse((String)stringValue, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                return DataConverter.localdatetimeToTimestamp(localDateTime);
            }
            case DOUBLE: {
                stringValue = stringValue.replaceAll(",", ".");
                return indexType.parse(stringValue);
            }
            case BOOLEAN: {
                boolean booleanValue = StringUtils.isBlank((String)stringValue) ? false : stringValue.toLowerCase().equals("true") || stringValue.equals("1");
                NativeSql databaseImpl = NativeDatabase.getImplementation();
                return databaseImpl.getBooleanValue(booleanValue);
            }
        }
        return indexType.parse(stringValue);
    }

    public static IndexFilter buildIndexFilter(String stringValue, DocumentClassIndex documentClassIndex) {
        SimpleIndexFilter indexFilter = null;
        if (StringUtils.isNotBlank((String)stringValue)) {
            Object value = DataConverter.indexConverter(stringValue, documentClassIndex.getType());
            indexFilter = new SimpleIndexFilter(documentClassIndex.getId(), value);
            log.debug("convert " + stringValue + " to " + indexFilter.getValue() + ", indexType: " + documentClassIndex.getType().name() + ", operator: " + indexFilter.getOperator().name());
        } else {
            GroupIndexFilter groupFilter = new GroupIndexFilter(LogicOperator.OR);
            groupFilter.addFilter((SQLFilter[])new IndexFilter[]{new SimpleIndexFilter(documentClassIndex.getId(), null, FilterOperator.ISNULL)});
            groupFilter.addFilter((SQLFilter[])new IndexFilter[]{new SimpleIndexFilter(documentClassIndex.getId(), (Object)"", FilterOperator.EQ)});
            indexFilter = groupFilter;
            log.debug("convert empty string to GroupIndexFilter with OR logic for index: " + documentClassIndex.getId());
        }
        return indexFilter;
    }

    public static LocalDate dateToLocalDate(Date d) {
        if (d == null) {
            return null;
        }
        return new LocalDate(d.getTime(), jodaTzUTC);
    }

    public static Date localdateToDate(LocalDate ld) {
        if (ld == null) {
            return null;
        }
        return new Date(ld.toDateTimeAtStartOfDay(jodaTzUTC).getMillis());
    }

    public static Timestamp localdatetimeToTimestamp(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        Long milis = ldt.toDateTime().getMillis();
        return new Timestamp(milis);
    }
}

