/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.attachment.applications;

import com.suncode.pdfutils.exception.CompressionFileSizeNotReachedException;
import com.suncode.pdfutils.exception.NotSupportedImageException;
import com.suncode.plugin.attachment.category.Categories;
import com.suncode.plugin.attachment.services.AttachDocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/compress-pdf-files-form.js")
public class CompressPdfFiles {
    private static final Logger log = LoggerFactory.getLogger(CompressPdfFiles.class);
    private static final double BYTES_TO_MB = 1048576.0;
    @Autowired
    private FileService fileService;
    @Autowired
    private AttachDocumentService attachDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("attachment.applications.CompressPdfFiles")).name("attachment.applications.CompressPdfFiles.name")).description("attachment.applications.CompressPdfFiles.desc")).category(new Category[]{Categories.ATTACHMENT})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("fileIds").name("attachment.applications.CompressPdfFiles.param.fileIds.name").description("attachment.applications.CompressPdfFiles.param.fileIds.desc").type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("compressionThresholdMB").name("attachment.applications.CompressPdfFiles.param.compressionThresholdMB.name").description("attachment.applications.CompressPdfFiles.param.compressionThresholdMB.desc").type((Type)Types.FLOAT).create()).parameter().id("saveAsNewVersion").name("attachment.applications.CompressPdfFiles.param.saveAsNewVersion.name").description("attachment.applications.CompressPdfFiles.param.saveAsNewVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("targetDocumentClassName").name("attachment.applications.CompressPdfFiles.param.targetDocumentClassName.name").description("attachment.applications.CompressPdfFiles.param.targetDocumentClassName.desc").type((Type)Types.STRING).optional().create()).parameter().id("addDocumentToProcess").name("attachment.applications.CompressPdfFiles.param.addDocumentToProcess.name").description("attachment.applications.CompressPdfFiles.param.addDocumentToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("executeArchiveActions").name("attachment.applications.CompressPdfFiles.param.executeArchiveActions.name").description("attachment.applications.CompressPdfFiles.param.executeArchiveActions.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(@Param Long[] fileIds, @Param Double compressionThresholdMB, @Param Boolean saveAsNewVersion, @Param String targetDocumentClassName, @Param Boolean addDocumentToProcess, @Param Boolean executeArchiveActions, ApplicationContext context) throws AcceptanceException {
        this.run(fileIds, compressionThresholdMB, saveAsNewVersion, targetDocumentClassName, addDocumentToProcess, executeArchiveActions, (WorkflowContext)context);
    }

    public void set(@Param Long[] fileIds, @Param Double compressionThresholdMB, @Param Boolean saveAsNewVersion, @Param String targetDocumentClassName, @Param Boolean addDocumentToProcess, @Param Boolean executeArchiveActions, AcceptanceContext context) throws AcceptanceException {
        this.run(fileIds, compressionThresholdMB, saveAsNewVersion, targetDocumentClassName, addDocumentToProcess, executeArchiveActions, (WorkflowContext)context);
    }

    private void run(Long[] fileIds, Double compressionThresholdMB, Boolean saveAsNewVersion, String targetDocumentClassName, Boolean addDocumentToProcess, Boolean executeArchiveActions, WorkflowContext context) throws AcceptanceException {
        for (Long fileId : fileIds) {
            WfFile file = this.fileService.getFile(fileId, new String[0]);
            Assert.notNull((Object)file, (String)"File does not exist in system archive");
            if (!this.isDocumentPDFFormat(file.getFileName()) || !this.shouldCompressFile(file, compressionThresholdMB)) continue;
            try {
                byte[] compressedPdfBytes = this.compressPdfFile(file.getId(), compressionThresholdMB);
                double compressedSizeMB = (double)compressedPdfBytes.length / 1048576.0;
                log.debug("File {} compressed to {} MB", (Object)file.getFileName(), (Object)compressedSizeMB);
                this.attachDocumentService.addFileToArchive(file, targetDocumentClassName, compressedPdfBytes, saveAsNewVersion, addDocumentToProcess, executeArchiveActions, context.getProcessId(), context.getActivityId());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AcceptanceException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean shouldCompressFile(WfFile file, double compressionThresholdMB) {
        double fileSizeMB = (double)file.getSize() / 1048576.0;
        log.debug("File {} size before compression {} MB", (Object)file.getFileName(), (Object)fileSizeMB);
        return fileSizeMB > compressionThresholdMB;
    }

    private boolean isDocumentPDFFormat(String fileName) {
        return FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("pdf");
    }

    /*
     * Exception decompiling
     */
    private byte[] compressPdfFile(long fileId, double thresholdMB) throws IOException, NotSupportedImageException, CompressionFileSizeNotReachedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

