var Action = {
        t: PW.I18N.createT('com.suncode.plugin-jabil')
};
/**
* Action that calculates payment term BD
 */
PW.FormActions.create('payment-terms-calculations-action', {

	init: function(){
        this.companyCode = this.get("companyCode"); 
        this.vendorCode = this.get("vendorCode");
        this.blindDate = this.get("blindDate");
        this.issueDate = this.get("issueDate");
        this.basicPaymentTerm = this.get("basicPaymentTerm"); 
    },
    enable : function(){
    	this.companyCode.on("change",  this.calculatePaymentTermsDB, this);
    	this.vendorCode.on("change",  this.calculatePaymentTermsDB, this);
    	this.blindDate.on("change",  this.calculatePaymentTermsDB, this);
    	this.issueDate.on("change",  this.calculatePaymentTermsDB, this);
    	this.basicPaymentTerm.on("change",  this.calculatePaymentTermsDB, this);
    },
    disable : function(){
    	this.companyCode.off("change", this.calculatePaymentTermsDB, this);
    	this.vendorCode.off("change", this.calculatePaymentTermsDB, this);
    	this.blindDate.off("change",  this.calculatePaymentTermsDB, this);
    	this.issueDate.off("change",  this.calculatePaymentTermsDB, this);
    	this.basicPaymentTerm.off("change", this.calculatePaymentTermsDB, this);
    },
    calculatePaymentTermsDB : function()
    {
    	SuncodeFormService.suspendLayouts();
    	try 
    	{
        	var params = 
        	{ 
        			companyCode:  VariableService.getValue(this.companyCode.id),
        			vendorCode: VariableService.getValue(this.vendorCode.id),
        			blindDate: VariableService.getValue(this.blindDate.id, true),
        			issueDate: VariableService.getValue(this.issueDate.id, true),
        			basicPaymentTerm: VariableService.getValue(this.basicPaymentTerm.id, true)
        	};
            this.getResponse(params);	
    	}
    	finally {
    	    SuncodeFormService.resumeLayouts();
    	}
    },
    getResponse: function( params )
    {
    	var request = jQuery.ajax({
    		url : "plugin/com.suncode.plugin-jabil/controller/getPaymentTermsDBData",
			type : "GET",
			data : params,
			async : false,
			error : function(jqXHR, textStatus, errorThrown) 
			{
				MessageService.showFailure( errorThrown );	
			}
		})
		.done(function(data) 
		{
			for( key in data )
			{
				VariableService.setValue( key , data[key], true );
		    }
		    FormService.save();
		})
		.fail(function(jqXHR, textStatus, errorThrown) {
			Logger.error("Request failed.");
			MessageService.showFailure(errorThrown);
		});
    }
});