/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dmhandler;

import com.plusmpm.directorymonitor.module.DocumentUploadListener;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectoryMonitorHandler
implements DocumentUploadListener {
    @Autowired
    private DocumentClassService documentClassService;
    private Logger log = LoggerFactory.getLogger(DirectoryMonitorHandler.class);
    private final String SAD_DOC_CLASS_NAME = "SAD";
    private final String SAD_DOC_CLASS_INDEX_NAME_INV_CODE = "Faktury powi\u0105zane - KOD";
    private final String SAD_DOC_CLASS_INDEX_NAME_INV = "Faktury powi\u0105zane";
    private final String SAD_DOC_CLASS_INDEX_NAME_DUTY_AMOUNT = "Kwota C\u0142o PLN";
    private final String SAD_DOC_CLASS_INDEX_NAME_VAT_AMOUNT = "Kwota VAT PLN";
    private final String SAD_DOC_CLASS_INDEX_NAME_FEE_BASE = "Podstawa op\u0142aty";
    private final String SAD_DOC_CLASS_INDEX_NAME_FEE_RATE = "Stawka op\u0142aty";
    private final String SAD_DOC_CLASS_INDEX_NAME_FEE_PAYMENT_METHOD = "Metoda p\u0142atno\u015bci op\u0142aty";
    private final String SAD_DOC_CLASS_INDEX_NAME_FEE_TYPE = "Typ op\u0142aty";
    private final String SAD_DOC_CLASS_INDEX_NAME_FEE_AMOUNT = "Kwota op\u0142aty";

    public void onDocumentUpload(DocumentDefinition definition) {
        DocumentClass docClass = (DocumentClass)this.documentClassService.get((Serializable)definition.getDocumentClassId(), new String[]{"indexes"});
        if (StringUtils.equals((CharSequence)"SAD", (CharSequence)docClass.getName())) {
            this.log.debug("Przetwarzanie indeks\u00f3w dla klasy dokument\u00f3w o nazwie [" + docClass.getName() + "]");
            Long invoicesCodesIndexId = this.getIndexIdByName(docClass, "Faktury powi\u0105zane - KOD");
            Long invoicesIndexId = this.getIndexIdByName(docClass, "Faktury powi\u0105zane");
            this.log.debug("Id indeksu kod\u00f3w faktur [" + invoicesCodesIndexId + "]");
            this.log.debug("Id indeksu numer\u00f3w faktur [" + invoicesIndexId + "]");
            if (invoicesCodesIndexId != null && invoicesIndexId != null) {
                this.setAssociatedInvoicesData(definition, invoicesCodesIndexId, invoicesIndexId);
            } else {
                if (invoicesCodesIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Faktury powi\u0105zane - KOD]");
                }
                if (invoicesIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Faktury powi\u0105zane]");
                }
            }
            Long dutyAmountIndexId = this.getIndexIdByName(docClass, "Kwota C\u0142o PLN");
            Long vatAmountIndexId = this.getIndexIdByName(docClass, "Kwota VAT PLN");
            this.log.debug("Id indeksu typ\u00f3w op\u0142at [" + dutyAmountIndexId + "]");
            this.log.debug("Id indeksu kwot op\u0142at [" + vatAmountIndexId + "]");
            if (dutyAmountIndexId != null && vatAmountIndexId != null) {
                this.setAmountData(definition, dutyAmountIndexId, vatAmountIndexId);
            } else {
                if (dutyAmountIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Kwota C\u0142o PLN]");
                }
                if (vatAmountIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Kwota VAT PLN]");
                }
            }
            Long feeBaseIndexId = this.getIndexIdByName(docClass, "Podstawa op\u0142aty");
            Long feeRateIndexId = this.getIndexIdByName(docClass, "Stawka op\u0142aty");
            Long feePaymentMethodIndexId = this.getIndexIdByName(docClass, "Metoda p\u0142atno\u015bci op\u0142aty");
            Long feeTypeIndexId = this.getIndexIdByName(docClass, "Typ op\u0142aty");
            Long feeAmountIndexId = this.getIndexIdByName(docClass, "Kwota op\u0142aty");
            this.log.debug("Id indeksu podstawy op\u0142aty [" + feeBaseIndexId + "]");
            this.log.debug("Id indeksu stawki op\u0142aty [" + feeRateIndexId + "]");
            this.log.debug("Id indeksu metody p\u0142atno\u015bci op\u0142aty [" + feePaymentMethodIndexId + "]");
            this.log.debug("Id indeksu typu op\u0142aty [" + feeTypeIndexId + "]");
            this.log.debug("Id indeksu kwoty op\u0142aty [" + feeAmountIndexId + "]");
            if (feeBaseIndexId != null && feeRateIndexId != null && feePaymentMethodIndexId != null && feeTypeIndexId != null && feeAmountIndexId != null) {
                this.setFeeData(definition, feeBaseIndexId, feeRateIndexId, feePaymentMethodIndexId, feeTypeIndexId, feeAmountIndexId);
            } else {
                if (feeBaseIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Podstawa op\u0142aty]");
                }
                if (feeRateIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Stawka op\u0142aty]");
                }
                if (feePaymentMethodIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Metoda p\u0142atno\u015bci op\u0142aty]");
                }
                if (feeTypeIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Typ op\u0142aty]");
                }
                if (feeAmountIndexId == null) {
                    this.log.debug("Nie znaleziono indeksu o nazwie [Kwota op\u0142aty]");
                }
            }
        }
    }

    private void setAssociatedInvoicesData(DocumentDefinition definition, Long invoicesCodesIndexId, Long invoicesIndexId) {
        ArrayList codesList = new ArrayList();
        ArrayList invoicesList = new ArrayList();
        HashSet<String> invoicesNoSet = new HashSet<String>();
        HashMap<Long, String> newIndexes = new HashMap<Long, String>();
        definition.getIndexes().forEach((id, value) -> {
            if (Long.compare(id, invoicesCodesIndexId) == 0) {
                codesList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Faktury powi\u0105zane - KOD] posiada warto\u015bci: " + codesList);
            } else if (Long.compare(id, invoicesIndexId) == 0) {
                invoicesList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Faktury powi\u0105zane] posiada warto\u015bci: " + invoicesList);
            } else {
                newIndexes.put((Long)id, (String)value);
            }
        });
        definition.setIndexes(newIndexes);
        if (!codesList.isEmpty() && !invoicesList.isEmpty()) {
            if (codesList.size() == invoicesList.size()) {
                ArrayList<String> newCodesList = new ArrayList<String>();
                ArrayList<String> newInvoicesList = new ArrayList<String>();
                if (codesList.contains("N935")) {
                    for (int i = 0; i < codesList.size(); ++i) {
                        boolean isAdded;
                        if (!StringUtils.equals((CharSequence)((CharSequence)codesList.get(i)), (CharSequence)"N935") || !(isAdded = invoicesNoSet.add((String)invoicesList.get(i)))) continue;
                        newCodesList.add((String)codesList.get(i));
                        newInvoicesList.add((String)invoicesList.get(i));
                    }
                } else {
                    for (int i = 0; i < codesList.size(); ++i) {
                        boolean isAdded;
                        if (!StringUtils.equals((CharSequence)((CharSequence)codesList.get(i)), (CharSequence)"N325") && !StringUtils.equals((CharSequence)((CharSequence)codesList.get(i)), (CharSequence)"N380") || !(isAdded = invoicesNoSet.add((String)invoicesList.get(i)))) continue;
                        newCodesList.add((String)codesList.get(i));
                        newInvoicesList.add((String)invoicesList.get(i));
                    }
                }
                newIndexes.put(invoicesCodesIndexId, StringUtils.join(newCodesList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Faktury powi\u0105zane - KOD] " + StringUtils.join(newCodesList, (String)";"));
                newIndexes.put(invoicesIndexId, StringUtils.join(newInvoicesList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Faktury powi\u0105zane] " + StringUtils.join(newInvoicesList, (String)";"));
                definition.setIndexes(newIndexes);
            } else {
                this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Faktury powi\u0105zane - KOD] i [Faktury powi\u0105zane]");
            }
        } else {
            this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Faktury powi\u0105zane - KOD] lub [Faktury powi\u0105zane]");
        }
    }

    private void setAmountData(DocumentDefinition definition, Long dutyAmountIndexId, Long vatAmountIndexId) {
        ArrayList chargeTypesList = new ArrayList();
        ArrayList chargeAmountsList = new ArrayList();
        HashMap<Long, Object> newIndexes = new HashMap<Long, Object>();
        definition.getIndexes().forEach((id, value) -> {
            if (Long.compare(id, dutyAmountIndexId) == 0) {
                chargeTypesList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Kwota C\u0142o PLN] posiada warto\u015bci: " + chargeTypesList);
            } else if (Long.compare(id, vatAmountIndexId) == 0) {
                chargeAmountsList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Kwota VAT PLN] posiada warto\u015bci: " + chargeAmountsList);
            } else {
                newIndexes.put((Long)id, value);
            }
        });
        definition.setIndexes(newIndexes);
        if (!chargeTypesList.isEmpty() && !chargeAmountsList.isEmpty()) {
            if (chargeTypesList.size() == chargeAmountsList.size()) {
                Double sumDutyAmount = 0.0;
                Double sumVATAmount = 0.0;
                for (int i = 0; i < chargeTypesList.size(); ++i) {
                    Double chargeAmount;
                    String chargType = (String)chargeTypesList.get(i);
                    if (StringUtils.startsWith((CharSequence)chargType, (CharSequence)"A")) {
                        chargeAmount = Double.valueOf((String)chargeAmountsList.get(i));
                        sumDutyAmount = Double.sum(sumDutyAmount, chargeAmount);
                        continue;
                    }
                    if (!StringUtils.startsWith((CharSequence)chargType, (CharSequence)"B")) continue;
                    chargeAmount = Double.valueOf((String)chargeAmountsList.get(i));
                    sumVATAmount = Double.sum(sumVATAmount, chargeAmount);
                }
                newIndexes.put(dutyAmountIndexId, String.valueOf(sumDutyAmount));
                this.log.debug("Nowa warto\u015bci dla indeksu [Kwota C\u0142o PLN] " + sumDutyAmount);
                newIndexes.put(vatAmountIndexId, sumVATAmount);
                this.log.debug("Nowa warto\u015bci dla indeksu [Kwota VAT PLN] " + sumVATAmount);
                definition.setIndexes(newIndexes);
            } else {
                this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Kwota C\u0142o PLN] i [Kwota VAT PLN]");
            }
        } else {
            this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Kwota C\u0142o PLN] lub [Kwota VAT PLN]");
        }
    }

    private void setFeeData(DocumentDefinition definition, Long feeBaseIndexId, Long feeRateIndexId, Long feePaymentMethodIndexId, Long feeTypeIndexId, Long feeAmountIndexId) {
        ArrayList feeBaseList = new ArrayList();
        ArrayList feeRateList = new ArrayList();
        ArrayList feePaymentMethodList = new ArrayList();
        ArrayList feeTypeList = new ArrayList();
        ArrayList feeAmountList = new ArrayList();
        HashMap<Long, String> newIndexes = new HashMap<Long, String>();
        definition.getIndexes().forEach((id, value) -> {
            if (Long.compare(id, feeBaseIndexId) == 0) {
                feeBaseList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Podstawa op\u0142aty] posiada warto\u015bci: " + feeBaseList);
            } else if (Long.compare(id, feeRateIndexId) == 0) {
                feeRateList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Stawka op\u0142aty] posiada warto\u015bci: " + feeRateList);
            } else if (Long.compare(id, feePaymentMethodIndexId) == 0) {
                feePaymentMethodList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Metoda p\u0142atno\u015bci op\u0142aty] posiada warto\u015bci: " + feePaymentMethodList);
            } else if (Long.compare(id, feeTypeIndexId) == 0) {
                feeTypeList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Typ op\u0142aty] posiada warto\u015bci: " + feeTypeList);
            } else if (Long.compare(id, feeAmountIndexId) == 0) {
                feeAmountList.addAll(Arrays.asList(StringUtils.split((String)String.valueOf(value), (String)";")));
                this.log.debug("Indeks o nazwie [Kwota op\u0142aty] posiada warto\u015bci: " + feeAmountList);
            } else {
                newIndexes.put((Long)id, (String)value);
            }
        });
        definition.setIndexes(newIndexes);
        if (!(feeBaseList.isEmpty() || feeRateList.isEmpty() || feeTypeList.isEmpty() || feeAmountList.isEmpty() || feePaymentMethodList.isEmpty())) {
            if (feeBaseList.size() == feeRateList.size() && feeBaseList.size() == feePaymentMethodList.size() && feeBaseList.size() == feeTypeList.size() && feeBaseList.size() == feeAmountList.size()) {
                ArrayList<String> newFeeBaseList = new ArrayList<String>();
                ArrayList<String> newFeeRateList = new ArrayList<String>();
                ArrayList<String> newFeePaymentMethodList = new ArrayList<String>();
                ArrayList<String> newFeeTypeList = new ArrayList<String>();
                ArrayList<String> newFeeAmountList = new ArrayList<String>();
                for (int i = 0; i < feeTypeList.size(); ++i) {
                    newFeeBaseList.add((String)feeBaseList.get(i));
                    newFeeRateList.add((String)feeRateList.get(i));
                    newFeeTypeList.add((String)feeTypeList.get(i));
                    newFeeAmountList.add((String)feeAmountList.get(i));
                    newFeePaymentMethodList.add((String)feePaymentMethodList.get(i));
                }
                newIndexes.put(feeBaseIndexId, StringUtils.join(newFeeBaseList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Podstawa op\u0142aty] " + StringUtils.join(newFeeBaseList, (String)";"));
                newIndexes.put(feeRateIndexId, StringUtils.join(newFeeRateList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Stawka op\u0142aty] " + StringUtils.join(newFeeRateList, (String)";"));
                newIndexes.put(feePaymentMethodIndexId, StringUtils.join(newFeePaymentMethodList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Metoda p\u0142atno\u015bci op\u0142aty] " + StringUtils.join(newFeePaymentMethodList, (String)";"));
                newIndexes.put(feeTypeIndexId, StringUtils.join(newFeeTypeList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Typ op\u0142aty] " + StringUtils.join(newFeeTypeList, (String)";"));
                newIndexes.put(feeAmountIndexId, StringUtils.join(newFeeAmountList, (String)";"));
                this.log.debug("Nowa warto\u015bci dla indeksu [Kwota op\u0142aty] " + StringUtils.join(newFeeAmountList, (String)";"));
                definition.setIndexes(newIndexes);
            } else {
                if (feeBaseList.size() != feeRateList.size()) {
                    this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Podstawa op\u0142aty] i [Stawka op\u0142aty]");
                }
                if (feeBaseList.size() != feePaymentMethodList.size()) {
                    this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Podstawa op\u0142aty] i [Metoda p\u0142atno\u015bci op\u0142aty]");
                }
                if (feeBaseList.size() != feeTypeList.size()) {
                    this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Podstawa op\u0142aty] i [Typ op\u0142aty]");
                }
                if (feeBaseList.size() != feeAmountList.size()) {
                    this.log.debug("Niezgodno\u015bci d\u0142ugo\u015bci listy warto\u015bci dla indeksu o nazwie [Podstawa op\u0142aty] i [Kwota op\u0142aty]");
                }
            }
        } else {
            if (feeBaseList.isEmpty()) {
                this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Podstawa op\u0142aty]");
            }
            if (feeRateList.isEmpty()) {
                this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Stawka op\u0142aty]");
            }
            if (feePaymentMethodList.isEmpty()) {
                this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Metoda p\u0142atno\u015bci op\u0142aty]");
            }
            if (feeTypeList.isEmpty()) {
                this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Typ op\u0142aty]");
            }
            if (feeAmountList.isEmpty()) {
                this.log.debug("Brak warto\u015bci dla indeksu o nazwie [Kwota op\u0142aty]");
            }
        }
    }

    private Long getIndexIdByName(DocumentClass documentClass, String indexName) {
        Set docClassIndexes = documentClass.getIndexes();
        for (DocumentClassIndex documentClassIndex : docClassIndexes) {
            if (!StringUtils.equals((CharSequence)documentClassIndex.getName(), (CharSequence)indexName)) continue;
            return documentClassIndex.getId();
        }
        return null;
    }
}

