/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.tasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.client.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class ReplaceInvoiceByOthers {
    private Logger log = Logger.getLogger(ReplaceInvoiceByOthers.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private CommentService commentService;
    private final String[] ASSIGNED_IMPORT_INVOICES_TABLE_COLUMN_IDS = new String[]{"pfi_nr_faktury_xml", "pfi_kod_faktury_xml", "pfi_nr_faktury_proces", "pfi_nr_dziennika_proces", "pfi_nr_kontrahenta", "pfi_kontrahent_proces", "pfi_data_wystawienia_pr", "pfi_kwota_do_rozliczeni", "pfi_waluta_proces", "pfi_odprawa_czesciowa_p", "pfi_podglad", "pfi_powiazano"};
    private final String[] INVOICES_TO_REPLACE_TABLE_COLUMN_IDS = new String[]{"fdp_nr_faktury_do_przyp", "fdp_nr_dziennika_do_prz", "fdp_nr_kontrahenta_do_p", "fdp_kontrahent_do_przyp", "fdp_data_wystawienia_do", "fdp_kwota_do_rozliczeni", "fdp_waluta_do_przypisan", "fdp_odprawa_czesciowa_d", "fdp_podglad"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("replace-invoice-by-others-app")).name("application.replace-invoice-by-others.name")).description("application.replace-invoice-by-others.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.TABLE_EDIT)).create();
    }

    public void execute(ApplicationContext context) {
        Map activityContext = this.activityService.getActivityContext(context.getProcessId(), context.getActivityId());
        Map processContext = this.processService.getProcessContext(context.getProcessId());
        ArrayList<Map> newAssignedInvTable = new ArrayList<Map>();
        try {
            List assignedInvTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)activityContext, (String[])this.ASSIGNED_IMPORT_INVOICES_TABLE_COLUMN_IDS);
            this.log.debug((Object)("assignedInvTable: " + assignedInvTable));
            for (Map assignedInvTableRow : assignedInvTable) {
                String invoiceNo = (String)assignedInvTableRow.get("pfi_nr_faktury_proces");
                if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                    ArrayList<String> newReplacedInvoices = new ArrayList<String>();
                    String invoiceToRaplace = (String)assignedInvTableRow.get("pfi_nr_faktury_xml");
                    List invToReplaceTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)activityContext, (String[])this.INVOICES_TO_REPLACE_TABLE_COLUMN_IDS);
                    this.log.debug((Object)("invToReplaceTable: " + invToReplaceTable));
                    for (Map invToReplaceTableRow : invToReplaceTable) {
                        HashMap<String, String> newRow = new HashMap<String, String>();
                        newRow.put("pfi_nr_faktury_xml", (String)assignedInvTableRow.get("pfi_nr_faktury_xml"));
                        newRow.put("pfi_kod_faktury_xml", (String)assignedInvTableRow.get("pfi_kod_faktury_xml"));
                        newRow.put("pfi_nr_faktury_proces", (String)invToReplaceTableRow.get("fdp_nr_faktury_do_przyp"));
                        newRow.put("pfi_nr_dziennika_proces", (String)invToReplaceTableRow.get("fdp_nr_dziennika_do_prz"));
                        newRow.put("pfi_nr_kontrahenta", (String)invToReplaceTableRow.get("fdp_nr_kontrahenta_do_p"));
                        newRow.put("pfi_kontrahent_proces", (String)invToReplaceTableRow.get("fdp_kontrahent_do_przyp"));
                        newRow.put("pfi_data_wystawienia_pr", (String)invToReplaceTableRow.get("fdp_data_wystawienia_do"));
                        newRow.put("pfi_kwota_do_rozliczeni", (String)invToReplaceTableRow.get("fdp_kwota_do_rozliczeni"));
                        newRow.put("pfi_waluta_proces", (String)invToReplaceTableRow.get("fdp_waluta_do_przypisan"));
                        newRow.put("pfi_odprawa_czesciowa_p", (String)invToReplaceTableRow.get("fdp_odprawa_czesciowa_d"));
                        newRow.put("pfi_podglad", (String)invToReplaceTableRow.get("fdp_podglad"));
                        newRow.put("pfi_powiazano", "TAK");
                        newAssignedInvTable.add(newRow);
                        newReplacedInvoices.add((String)invToReplaceTableRow.get("fdp_nr_faktury_do_przyp"));
                    }
                    this.addCommentWithUpdatedInvoices(invoiceToRaplace, newReplacedInvoices, context.getProcessId(), context.getActivityId());
                    continue;
                }
                newAssignedInvTable.add(assignedInvTableRow);
            }
            for (String varId : this.INVOICES_TO_REPLACE_TABLE_COLUMN_IDS) {
                activityContext.put(varId, "");
            }
            this.log.debug((Object)("newAssignedInvTable: " + newAssignedInvTable));
            Map valuesToReplace = DynamicTableFunctions.convertFromListOfMapsToMap(newAssignedInvTable, (String[])this.ASSIGNED_IMPORT_INVOICES_TABLE_COLUMN_IDS);
            activityContext.putAll(valuesToReplace);
            this.activityService.setActivityContext(context.getProcessId(), context.getActivityId(), activityContext);
            processContext.putAll(valuesToReplace);
            this.processService.setProcessContext(context.getProcessId(), processContext);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void addCommentWithUpdatedInvoices(String invoiceToRaplace, List<String> newReplacedInvoices, String processId, String activityId) {
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(activityId);
        comment.setUserId("admin");
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment("Podmioniono faktur\u0119 o numerze " + invoiceToRaplace + " na " + StringUtils.join(newReplacedInvoices, (String)", "));
        this.commentService.createComment(comment);
    }
}

