/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.client.setters;

import com.suncode.plugin.client.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
public class UpdateTaskVariables {
    private Logger log = LoggerFactory.getLogger(UpdateTaskVariables.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("update-task-variables-setter")).name("setter.update-task-variables.name")).description("setter.update-task-variables.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.ARROW_REFRESH)).parameter().id("variableToUpdate").name("setter.update-task-variables.variableToUpdate.name").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("taskDefId").name("setter.update-task-variables.taskDefId.name").description("setter.update-task-variables.taskDefId.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void set(@Param Variable[] variableToUpdate, @Param String[] taskDefId, AcceptanceContext acceptanceContext) {
        Set taskDefIds = Arrays.stream(taskDefId).collect(Collectors.toSet());
        List openedActivities = this.activityFinder.findOpenedActivities(acceptanceContext.getProcessId());
        for (Activity activity : openedActivities) {
            if (!taskDefIds.contains(activity.getActivityDefinitionId())) continue;
            this.log.debug(activity.getActivityId() + " is prrocessing...");
            Map context = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            for (String key : context.keySet()) {
                for (Variable var : variableToUpdate) {
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)var.getId())) continue;
                    this.log.debug("Updating " + key + " from <" + context.get(key) + "> to <" + var.getValue() + ">");
                    context.put(key, var.getValue());
                }
            }
            this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), context);
        }
    }
}

